/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.ffenchants.enchantments;

import com.flashfyre.ffenchants.FFEnchantments;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ffenchants")
public class VampiricEnchantment
extends Enchantment {
    public VampiricEnchantment(Enchantment.Rarity rarity, EnchantmentType type, EquipmentSlotType ... slots) {
        super(rarity, type, slots);
        this.setRegistryName("ffenchants", "vampiric");
    }

    @SubscribeEvent
    public static void mobHealOnHit(LivingDamageEvent event) {
        Entity attacker = event.getSource().func_76364_f();
        if (attacker instanceof PlayerEntity) {
            return;
        }
        VampiricEnchantment.heal(attacker, (Entity)event.getEntityLiving());
    }

    @SubscribeEvent
    public static void playerHealOnHit(AttackEntityEvent event) {
        PlayerEntity wielder = event.getPlayer();
        if (!wielder.func_70996_bM()) {
            return;
        }
        if (wielder.func_184825_o(0.0f) < 1.0f) {
            return;
        }
        VampiricEnchantment.heal((Entity)wielder, event.getTarget());
    }

    public static void heal(Entity attacker, Entity target) {
        if (target instanceof LivingEntity && attacker instanceof LivingEntity) {
            Random r;
            World world;
            LivingEntity livingTarget = (LivingEntity)target;
            LivingEntity livingAttacker = (LivingEntity)attacker;
            if (livingTarget.func_70662_br()) {
                return;
            }
            ItemStack heldItem = livingAttacker.func_184586_b(Hand.MAIN_HAND);
            if (heldItem.func_190926_b()) {
                return;
            }
            int level = EnchantmentHelper.func_77506_a((Enchantment)FFEnchantments.VAMPIRIC, (ItemStack)heldItem);
            if (level > 0 && !(world = livingAttacker.field_70170_p).func_201670_d() && world instanceof ServerWorld && (r = livingAttacker.func_70681_au()).nextInt(6 - level) == 0) {
                livingAttacker.func_70691_i(2.0f);
                world.func_184133_a(null, livingAttacker.func_180425_c(), SoundEvents.field_191244_bn, SoundCategory.MASTER, 1.0f, 1.0f);
                ServerWorld serverWorld = (ServerWorld)livingAttacker.field_70170_p;
                serverWorld.func_195598_a((IParticleData)ParticleTypes.field_197633_z, (double)livingAttacker.func_180425_c().func_177958_n() + 0.5, (double)livingAttacker.func_180425_c().func_177956_o() + 1.5, (double)livingAttacker.func_180425_c().func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    public int func_77325_b() {
        return 2;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 1 + enchantmentLevel * 5;
    }

    public boolean func_185261_e() {
        return true;
    }
}

