/*
 * Decompiled with CFR 0.152.
 */
package com.flashfyre.ffenchants.misc;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.flashfyre.ffenchants.FFEnchantments;
import java.io.File;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Config {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec CONFIG;
    public static ForgeConfigSpec.BooleanValue enableBloodlust;
    public static ForgeConfigSpec.BooleanValue enableVampiric;
    public static ForgeConfigSpec.BooleanValue enablePillaging;
    public static ForgeConfigSpec.BooleanValue enableWeighted;
    public static ForgeConfigSpec.BooleanValue enablePoisonAspect;
    public static ForgeConfigSpec.BooleanValue enableWitherAspect;
    public static ForgeConfigSpec.BooleanValue enableSearing;
    public static ForgeConfigSpec.BooleanValue enableSharpshooter;
    public static ForgeConfigSpec.BooleanValue enableSteadfast;
    public static ForgeConfigSpec.BooleanValue enableTorrent;
    public static ForgeConfigSpec.BooleanValue enableRejuvenation;

    public static void loadConfig(ForgeConfigSpec config, String path) {
        FFEnchantments.LOGGER.info("Loading config: " + path);
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        FFEnchantments.LOGGER.info("Built config: " + path);
        file.load();
        FFEnchantments.LOGGER.info("Loaded config: " + path);
        config.setConfig((CommentedConfig)file);
    }

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.comment("FlashFyre's Enchantments Config");
        enableBloodlust = builder.comment("Enable Bloodlust").define("ffeconfig.enableBloodlust", true);
        enableVampiric = builder.comment("Enable Vampiric").define("ffeconfig.enableVampiric", true);
        enablePillaging = builder.comment("Enable Pillaging").define("ffeconfig.enablePillaging", true);
        enableWeighted = builder.comment("Enable Weighted").define("ffeconfig.enableWeighted", true);
        enablePoisonAspect = builder.comment("Enable Poison Aspect").define("ffeconfig.enablePoisonAspect", true);
        enableWitherAspect = builder.comment("Enable Wither Aspect").define("ffeconfig.enableWitherAspect", true);
        enableSearing = builder.comment("Enable Searing").define("ffeconfig.enableSearing", true);
        enableSharpshooter = builder.comment("Enable Sharpshooter").define("ffeconfig.enableSharpshooter", true);
        enableSteadfast = builder.comment("Enable Steadfast").define("ffeconfig.enableSteadfast", true);
        enableTorrent = builder.comment("Enable Torrent").define("ffeconfig.enableTorrent", true);
        enableRejuvenation = builder.comment("Enable Neptune's Rejuvenation").define("ffeconfig.enableRejuvenation", true);
    }

    static {
        Config.init(BUILDER);
        CONFIG = BUILDER.build();
    }
}

