/*
 * Decompiled with CFR 0.152.
 */
package com.fgtXray.config;

import com.fgtXray.reference.OreInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.config.Configuration;

public class DefaultConfig {
    static final Map<String, OreInfo> defaults = new HashMap<String, OreInfo>(){
        {
            this.put("oreLapis", new OreInfo("Lapis", 0, 0, 255, false));
            this.put("oreCopper", new OreInfo("Copper", 0, 0, 0xCC6600, true));
            this.put("oreTin", new OreInfo("Tin", 0, 0, 0xA1A1A1, true));
            this.put("oreCobalt", new OreInfo("Cobalt", 0, 0, 255, false));
            this.put("oreArdite", new OreInfo("Ardite", 0, 0, 0xFF9900, false));
            this.put("oreCertusQuartz", new OreInfo("Certus Quartz", 0, 0, 0xFFFFFF, false));
            this.put("oreUranium", new OreInfo("Uranium", 0, 0, 65280, true));
            this.put("oreDiamond", new OreInfo("Diamond", 0, 0, 0x8888FF, false));
            this.put("blockDiamond", new OreInfo("Diamond Block", 0, 0, 0x8888FF, false));
            this.put("oreEmerald", new OreInfo("Emerald", 0, 0, 34832, true));
            this.put("oreGold", new OreInfo("Gold", 0, 0, 0xFFFF00, false));
            this.put("blockGold", new OreInfo("Gold Block", 0, 0, 0xFFFF00, false));
            this.put("oreRedstone", new OreInfo("Redstone", 0, 0, 0xFF0000, false));
            this.put("oreIron", new OreInfo("Iron", 0, 0, 11171109, false));
            this.put("oreSilver", new OreInfo("Silver", 0, 0, 0x8F8F8F, false));
            this.put("mossystone", new OreInfo("Mossy Stone", 0, 0, 1985024, false));
            this.put("oreQuartz", new OreInfo("Quartz", 0, 0, 0x8888FF, false));
            this.put("oreCoal", new OreInfo("Coal", 0, 0, 0, false));
            this.put("blockGlass", new OreInfo("Glass", 0, 0, 0x8888FF, false));
        }
    };
    static final List<OreInfo> custom = new ArrayList<OreInfo>(){
        {
            this.add(new OreInfo("Redstone Wire", Block.func_149682_b((Block)Blocks.field_150488_af), 0, 0xFF0000, false));
            this.add(new OreInfo("Chest", Block.func_149682_b((Block)Blocks.field_150486_ae), 0, 0xFF00FF, true));
        }
    };

    public static void create(Configuration config) {
        config.get("general", "searchdist", 0);
        for (Map.Entry<String, OreInfo> entry : defaults.entrySet()) {
            String key = entry.getKey();
            OreInfo value = entry.getValue();
            String category = value.oreName.replaceAll("\\s+", "").toLowerCase();
            config.get("oredict." + category, "dictname", "SOMETHINGBROKE").set(key);
            config.get("oredict." + category, "guiname", "SOMETHINGBROKE").set(value.oreName);
            config.get("oredict." + category, "id", -1).set(value.id);
            config.get("oredict." + category, "meta", -1).set(value.meta);
            config.get("oredict." + category, "color", -1).set(value.color);
            config.get("oredict." + category, "enabled", false).set(value.draw);
        }
        for (OreInfo oreInfo : custom) {
            String name = oreInfo.oreName.replaceAll("\\s+", "").toLowerCase();
            config.get("customores." + name, "name", "SOMETHINGBROKE").set(oreInfo.oreName);
            config.get("customores." + name, "id", -1).set(oreInfo.id);
            config.get("customores." + name, "meta", -1).set(oreInfo.meta);
            config.get("customores." + name, "color", -1).set(oreInfo.color);
            config.get("customores." + name, "enabled", false).set(oreInfo.draw);
        }
    }
}

