/*
 * Decompiled with CFR 0.152.
 */
package com.fgtXray.client;

import com.fgtXray.FgtXRay;
import com.fgtXray.config.ConfigHandler;
import com.fgtXray.reference.OreInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.oredict.OreDictionary;

public class OresSearch {
    public static List<OreInfo> searchList = new ArrayList<OreInfo>();
    public static Minecraft mc = Minecraft.func_71410_x();

    private static boolean checkList(List<OreInfo> temp, OreInfo value, ItemStack stack) {
        for (OreInfo oreCheck : temp) {
            if (oreCheck.oreName != value.oreName || oreCheck.id != Item.func_150891_b((Item)stack.func_77973_b()) || oreCheck.meta != stack.func_77952_i()) continue;
            return true;
        }
        return false;
    }

    public static void add(String oreIdent, String name, int[] color) {
        oreIdent = oreIdent.replaceAll("\\p{C}", "?");
        int id = 0;
        int meta = 0;
        if (oreIdent.contains(":")) {
            String[] splitArray = oreIdent.split(":");
            if (splitArray.length != 2) {
                String notify = String.format("[\u00ef\u00bf\u00bdaFgt XRay\u00ef\u00bf\u00bdr] %s is not a valid identifier. Try id:meta (example 1:0 for stone) or oreName (example oreDiamond or mossyStone)", oreIdent);
                OresSearch.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(notify));
                return;
            }
            try {
                id = Integer.parseInt(splitArray[0]);
                meta = Integer.parseInt(splitArray[1]);
            }
            catch (NumberFormatException e) {
                String notify = String.format("[\u00ef\u00bf\u00bdaFgt XRay\u00ef\u00bf\u00bdr] %s contains data other than numbers and the colon. Failed to add.", oreIdent);
                OresSearch.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(notify));
                return;
            }
        }
        try {
            id = Integer.parseInt(oreIdent);
            meta = 0;
        }
        catch (NumberFormatException e) {
            String notify = String.format("[\u00ef\u00bf\u00bdaFgt XRay\u00ef\u00bf\u00bdr] Doesn't support in-game additions to the ore dictionary yet.. Failed to add.", new Object[0]);
            OresSearch.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(notify));
            return;
        }
        searchList.add(new OreInfo(name, id, meta, color, true));
        String notify = String.format("[\u00ef\u00bf\u00bdaFgt XRay\u00ef\u00bf\u00bdr] successfully added %s.", oreIdent);
        OresSearch.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(notify));
        ConfigHandler.add(name, oreIdent, color);
    }

    public static List<OreInfo> get() {
        if (searchList.isEmpty()) {
            System.out.println("[Fgt XRay] --- Populating the searchList with the ore dictionary --- ");
            ArrayList<OreInfo> temp = new ArrayList<OreInfo>();
            HashMap<String, OreInfo> tempOredict = new HashMap<String, OreInfo>();
            for (String oreName : OreDictionary.getOreNames()) {
                if (!FgtXRay.oredictOres.containsKey(oreName)) continue;
                tempOredict.put(oreName, FgtXRay.oredictOres.get(oreName));
            }
            for (Map.Entry entry : FgtXRay.oredictOres.entrySet()) {
                String key = (String)entry.getKey();
                if (tempOredict.containsKey(key)) continue;
                System.out.println(String.format("[Fgt XRay] Ore %s doesn't exist in dictionary! Deleting.", key));
            }
            FgtXRay.oredictOres.clear();
            FgtXRay.oredictOres.putAll(tempOredict);
            tempOredict.clear();
            for (Map.Entry entry : FgtXRay.oredictOres.entrySet()) {
                String key = (String)entry.getKey();
                OreInfo value = (OreInfo)entry.getValue();
                List oreDictOres = OreDictionary.getOres((String)key);
                if (oreDictOres.size() < 1) {
                    System.out.println(String.format("[Fgt XRay] Ore %s doesn't exist! Skipping. (We shouldn't have this issue here! Please tell me about this!)", key));
                    continue;
                }
                for (int i = 0; i < oreDictOres.size(); ++i) {
                    ItemStack oreItem = (ItemStack)oreDictOres.get(i);
                    if (OresSearch.checkList(temp, value, oreItem)) {
                        System.out.println("[Fgt XRay] Duplicate ore found in Ore Dictionary!!! (" + key + ")");
                        continue;
                    }
                    temp.add(new OreInfo(value.oreName, Item.func_150891_b((Item)oreItem.func_77973_b()), oreItem.func_77952_i(), value.color, value.draw));
                }
            }
            System.out.println("[Fgt XRay] --- Done populating searchList! --- ");
            System.out.println("[Fgt XRay] --- Adding custom blocks --- ");
            for (OreInfo oreInfo : FgtXRay.customOres) {
                System.out.println(String.format("[Fgt XRay] Adding OreInfo( %s, %d, %d, %b ) ", oreInfo.oreName, oreInfo.id, oreInfo.meta, oreInfo.draw));
                temp.add(oreInfo);
            }
            System.out.println("[Fgt XRay] --- Done adding custom blocks --- ");
            searchList.clear();
            searchList.addAll(temp);
        }
        return searchList;
    }
}

