/*
 * Decompiled with CFR 0.152.
 */
package com.fgtXray.config;

import com.fgtXray.FgtXRay;
import com.fgtXray.reference.OreInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class ConfigHandler {
    public static Configuration config = null;
    public static Minecraft mc = Minecraft.func_71410_x();

    public static void setup(FMLPreInitializationEvent event) {
        config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        FgtXRay.distIndex = config.get("general", "searchdist", 0).getInt();
        for (String category : config.getCategoryNames()) {
            ConfigCategory cat = config.getCategory(category);
            if (category.startsWith("oredict.")) {
                String dictName = cat.get("dictname").getString();
                String guiName = cat.get("guiname").getString();
                int id = cat.get("id").getInt();
                int meta = cat.get("meta").getInt();
                int[] color = new int[]{cat.get("red").getInt(), cat.get("green").getInt(), cat.get("blue").getInt()};
                boolean enabled = cat.get("enabled").getBoolean(false);
                FgtXRay.oredictOres.put(dictName, new OreInfo(guiName, id, meta, color, enabled));
                continue;
            }
            if (!category.startsWith("customores.")) continue;
            String name = cat.get("name").getString();
            int id = cat.get("id").getInt();
            int meta = cat.get("meta").getInt();
            int[] color = new int[]{cat.get("red").getInt(), cat.get("green").getInt(), cat.get("blue").getInt()};
            boolean enabled = cat.get("enabled").getBoolean(false);
            FgtXRay.customOres.add(new OreInfo(name, id, meta, color, enabled));
        }
        config.save();
    }

    public static void add(String oreName, String ore, int[] color) {
        config.load();
        String formattedname = oreName.replace("\\s+", "").toLowerCase();
        for (String category : config.getCategoryNames()) {
            if (!category.startsWith("customores.") || config.get("customores." + formattedname, "name", "").getString() != formattedname) continue;
            String notify = String.format("[Fgt XRay] %s already exists. Please enter a different name. ", oreName);
            ConfigHandler.mc.field_71456_v.func_146158_b().func_146227_a((ITextComponent)new TextComponentString(notify));
            return;
        }
        int oreId = Integer.parseInt(ore.split(":")[0]);
        int oreMeta = ore.contains(":") ? Integer.parseInt(ore.split(":")[1]) : 0;
        for (String category : config.getCategoryNames()) {
            if (!category.startsWith("customores.")) continue;
            config.get("customores." + formattedname, "red", "").set(color[0]);
            config.get("customores." + formattedname, "green", "").set(color[1]);
            config.get("customores." + formattedname, "blue", "").set(color[2]);
            config.get("customores." + formattedname, "enabled", "false").set(true);
            config.get("customores." + formattedname, "id", "").set(oreId);
            config.get("customores." + formattedname, "meta", "").set(oreMeta);
            config.get("customores." + formattedname, "name", "").set(oreName);
        }
        config.save();
    }

    public static void update(String string, boolean draw) {
        if (string.equals("searchdist")) {
            config.get("general", "searchdist", 0).set(FgtXRay.distIndex);
            config.save();
            return;
        }
        for (String category : config.getCategoryNames()) {
            String cleanStr = string.replaceAll("\\s+", "").toLowerCase();
            String[] splitCat = category.split("\\.");
            if (splitCat.length != 2) continue;
            if (splitCat[0].equals("oredict") && splitCat[1].equals(cleanStr)) {
                config.get("oredict." + cleanStr, "enabled", false).set(draw);
                continue;
            }
            if (!splitCat[0].equals("customores") || !splitCat[1].equals(cleanStr)) continue;
            config.get("customores." + cleanStr, "enabled", false).set(draw);
        }
        config.save();
    }

    public static void remove(String name) {
    }
}

