/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWImage;

public class CursorConfig {
    private int xHotSpot;
    private int yHotSpot;
    private String link;
    private long cursor = 0L;
    private GLFWImage glfwImage = GLFWImage.create();

    public static CursorConfig read(String path, CommentedFileConfig config, CursorConfig defaultConfig) {
        CursorConfig cursor = new CursorConfig();
        cursor.xHotSpot = config.getIntOrElse(path + ".xHotSpot", defaultConfig.xHotSpot);
        cursor.yHotSpot = config.getIntOrElse(path + ".yHotSpot", defaultConfig.yHotSpot);
        cursor.link = (String)config.getOrElse(path + ".link", (Object)defaultConfig.link);
        return cursor;
    }

    private CursorConfig() {
    }

    public CursorConfig(String link) {
        this(link, 0, 0);
    }

    public CursorConfig(String link, int xHotSpot, int yHotSpot) {
        this.xHotSpot = xHotSpot;
        this.yHotSpot = yHotSpot;
        this.link = link;
    }

    private void allocate() {
        this.readImage();
        if (this.cursor != 0L) {
            this.freeCursor();
        }
        this.cursor = GLFW.glfwCreateCursor((GLFWImage)this.glfwImage, (int)this.getxHotSpot(), (int)this.getyHotSpot());
    }

    public CursorConfig copy() {
        CursorConfig config = new CursorConfig(this.link, this.xHotSpot, this.yHotSpot);
        return config;
    }

    public void freeCursor() {
        if (this.isAllocate()) {
            GLFW.glfwDestroyCursor((long)this.cursor);
        }
    }

    public long getCursor() {
        if (this.cursor == 0L) {
            this.allocate();
        }
        return this.cursor;
    }

    public String getLink() {
        return this.link;
    }

    public IResource getResource() {
        try {
            return Minecraft.func_71410_x().func_195551_G().func_199002_a(this.getResourceLocation());
        }
        catch (Exception e) {
            return null;
        }
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation(this.link);
    }

    public int getxHotSpot() {
        return this.xHotSpot;
    }

    public int getyHotSpot() {
        return this.yHotSpot;
    }

    public boolean isAllocate() {
        return this.cursor != 0L;
    }

    private void readImage() {
        try {
            BufferedImage image = ImageIO.read(this.getResource().func_199027_b());
            int w = image.getWidth();
            int h = image.getHeight();
            int[] pixels = new int[w * h];
            image.getRGB(0, 0, w, h, pixels, 0, w);
            ByteBuffer buffer = BufferUtils.createByteBuffer((int)(w * h * 4));
            for (int y = h - 1; y >= 0; --y) {
                for (int x = 0; x < w; ++x) {
                    int pixel = pixels[(h - 1 - y) * w + x];
                    buffer.put((byte)(pixel & 0xFF));
                    buffer.put((byte)(pixel >> 8 & 0xFF));
                    buffer.put((byte)(pixel >> 16 & 0xFF));
                    buffer.put((byte)(pixel >> 24 & 0xFF));
                }
            }
            buffer.flip();
            this.glfwImage.pixels(buffer).width(w).height(h);
        }
        catch (IOException | NullPointerException e) {
            e.printStackTrace();
        }
    }

    public void setLink(String link) {
        if (this.cursor != 0L) {
            this.allocate();
        }
        this.link = link;
    }

    public void setxHotSpot(int xHotSpot) {
        if (this.cursor != 0L) {
            this.allocate();
        }
        this.xHotSpot = xHotSpot;
    }

    public void setyHotSpot(int yHotSpot) {
        if (this.cursor != 0L) {
            this.allocate();
        }
        this.yHotSpot = yHotSpot;
    }

    public void write(String path, CommentedFileConfig config) {
        config.set(path + ".xHotSpot", (Object)this.xHotSpot);
        config.set(path + ".yHotSpot", (Object)this.yHotSpot);
        config.set(path + ".link", (Object)this.link);
    }
}

