/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod;

import com.mojang.blaze3d.systems.RenderSystem;
import fr.atesab.customcursormod.Configuration;
import fr.atesab.customcursormod.CursorClick;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiConfig;
import fr.atesab.customcursormod.gui.GuiSelectZone;
import fr.atesab.customcursormod.gui.GuiUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.button.AbstractButton;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.gui.screen.ModListScreen;
import net.minecraftforge.fml.client.gui.widget.ModListWidget;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import org.lwjgl.glfw.GLFW;

@OnlyIn(value=Dist.CLIENT)
@Mod(value="customcursormod")
public class CursorMod {
    public static final String MOD_ID = "customcursormod";
    public static final String MOD_NAME = "Custom Cursor Mod";
    public static final String MOD_VERSION = "1.2.2";
    public static final String MOD_GUI_FACTORY = "fr.atesab.customcursormod.gui.GuiFactoryCursorMod";
    public static final Logger logger = Logger.getLogger("Custom Cursor Mod");
    private static boolean forceNextCursor = false;
    private static CursorType currentCursorType = CursorType.POINTER;
    private static Map<CursorType, CursorConfig> cursors = new HashMap<CursorType, CursorConfig>();
    private static List<CursorClick> cursorClicks = new ArrayList<CursorClick>();
    private static Configuration config = new Configuration();

    private static void changeCursor(CursorType cursor) {
        CursorMod.changeCursor(cursor, forceNextCursor);
        forceNextCursor = false;
    }

    private static void changeCursor(CursorType cursor, boolean forceChange) {
        if (!forceChange && cursor == currentCursorType) {
            return;
        }
        currentCursorType = cursor;
        CursorConfig cursorConfig = cursors.getOrDefault(cursor, cursor.getDefaultConfig());
        long cursorPtr = cursorConfig.getCursor();
        if (cursorPtr == 0L) {
            throw new NullPointerException();
        }
        GLFW.glfwSetCursor((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (long)cursorPtr);
    }

    public static void forceNextCursor() {
        forceNextCursor = CursorMod.config.dynamicCursor;
    }

    public static Configuration getConfig() {
        return config;
    }

    public static Map<CursorType, CursorConfig> getCursors() {
        return cursors;
    }

    public static void registerCursor(CursorType ... cursorTypes) {
        for (CursorType cursorType : cursorTypes) {
            cursors.put(cursorType, cursorType.getDefaultConfig());
        }
    }

    public static void replaceCursor(CursorType type, CursorConfig config) {
        CursorConfig old = cursors.put(type, config);
        if (type == currentCursorType) {
            CursorMod.changeCursor(type, true);
        }
        if (old.isAllocate()) {
            old.freeCursor();
        }
    }

    public static void saveConfig() {
        config.save();
    }

    public CursorMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerExtensionPoint(ExtensionPoint.CONFIGGUIFACTORY, () -> (mc, parent) -> new GuiConfig((Screen)parent));
        CursorMod.registerCursor(currentCursorType, CursorType.HAND, CursorType.HAND_GRAB, CursorType.BEAM, CursorType.CROSS);
    }

    private void checkModList(Screen screen) {
        Optional op;
        ModInfo info;
        ModListWidget.ModEntry entry;
        if (screen != null && screen instanceof ModListScreen && (entry = this.getFirstFieldOfTypeInto(ModListWidget.ModEntry.class, screen)) != null && (info = entry.getInfo()) != null && (op = ModList.get().getModContainerById(info.getModId())).isPresent()) {
            boolean value = ((ModContainer)op.get()).getCustomExtension(ExtensionPoint.CONFIGGUIFACTORY).isPresent();
            String configText = I18n.func_135052_a((String)"fml.menu.mods.config", (Object[])new Object[0]);
            for (IGuiEventListener b : screen.func_231039_at__()) {
                if (!(b instanceof Button) || !((Button)b).func_230458_i_().getString().equals(configText)) continue;
                ((Button)b).field_230693_o_ = value;
            }
        }
    }

    private List<Field[]> getDeclaredField(Class<?> cls) {
        ArrayList<Field[]> l = new ArrayList<Field[]>();
        l.add(cls.getDeclaredFields());
        while (!cls.equals(Object.class)) {
            cls = cls.getSuperclass();
            l.add(cls.getDeclaredFields());
        }
        return l;
    }

    private <T> T getFirstFieldOfTypeInto(Class<T> cls, Object obj) {
        for (Field f : obj.getClass().getDeclaredFields()) {
            f.setAccessible(true);
            if (f.getType() != cls) continue;
            try {
                return (T)f.get(obj);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                return null;
            }
        }
        return null;
    }

    private boolean isHover(int mouseX, int mouseY, int x, int y, int width, int height) {
        x = Math.min(x + width, x);
        y = Math.min(y + height, y);
        width = Math.abs(width);
        height = Math.abs(height);
        return mouseX >= x && mouseX < x + width && mouseY >= y && mouseY < y + height;
    }

    private boolean isHoverButton(int mouseX, int mouseY, AbstractButton button) {
        return button != null && button.field_230694_p_ && button.field_230693_o_ && this.isHover(mouseX, mouseY, button.field_230690_l_, button.field_230691_m_, button.func_230998_h_(), button.func_238483_d_());
    }

    private boolean isHoverTextField(int mouseX, int mouseY, TextFieldWidget textField) {
        return textField != null && textField.func_146176_q() && this.isHover(mouseX, mouseY, textField.field_230690_l_, textField.field_230691_m_, textField.func_230998_h_(), textField.func_238483_d_());
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post ev) {
        Screen gui = ev.getGui();
        CursorType newCursorType = CursorType.POINTER;
        if (CursorMod.config.dynamicCursor) {
            for (Field[] fa : this.getDeclaredField(gui.getClass())) {
                block3: for (Field f : fa) {
                    try {
                        f.setAccessible(true);
                        Object o = f.get(gui);
                        if (o == null) continue;
                        if (o instanceof TextFieldWidget) {
                            if (!this.isHoverTextField(ev.getMouseX(), ev.getMouseY(), (TextFieldWidget)o)) continue;
                            newCursorType = CursorType.BEAM;
                            continue;
                        }
                        if (o instanceof AbstractButton) {
                            if (!this.isHoverButton(ev.getMouseX(), ev.getMouseY(), (AbstractButton)((Button)o))) continue;
                            newCursorType = CursorType.HAND;
                            continue;
                        }
                        if (o instanceof GuiSelectZone) {
                            GuiSelectZone selectZone = (GuiSelectZone)o;
                            if (!this.isHover(ev.getMouseX(), ev.getMouseY(), selectZone.xPosition, selectZone.yPosition, selectZone.width, selectZone.height) || !selectZone.enable) continue;
                            newCursorType = CursorType.CROSS;
                            continue;
                        }
                        if (!(o instanceof Iterable)) continue;
                        for (Object e : (Iterable)o) {
                            if (e instanceof AbstractButton) {
                                if (!this.isHoverButton(ev.getMouseX(), ev.getMouseY(), (AbstractButton)e)) continue;
                                newCursorType = CursorType.HAND;
                                continue;
                            }
                            if (e instanceof TextFieldWidget) {
                                if (!this.isHoverTextField(ev.getMouseX(), ev.getMouseY(), (TextFieldWidget)e)) continue;
                                newCursorType = CursorType.BEAM;
                                continue;
                            }
                            if (!(e instanceof GuiSelectZone)) continue block3;
                            GuiSelectZone selectZone = (GuiSelectZone)e;
                            if (!this.isHover(ev.getMouseX(), ev.getMouseY(), selectZone.xPosition, selectZone.yPosition, selectZone.width, selectZone.height) || !selectZone.enable) continue;
                            newCursorType = CursorType.CROSS;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            if (gui instanceof ContainerScreen) {
                ContainerScreen container = (ContainerScreen)gui;
                if (gui.getMinecraft().field_71439_g.field_71071_by.func_70445_o() != null && !gui.getMinecraft().field_71439_g.field_71071_by.func_70445_o().func_77973_b().equals(Items.field_190931_a)) {
                    newCursorType = CursorType.HAND_GRAB;
                } else if (container.getSlotUnderMouse() != null && container.getSlotUnderMouse().func_75216_d()) {
                    newCursorType = CursorType.HAND;
                }
            } else if (gui instanceof ChatScreen) {
                Minecraft mc = gui.getMinecraft();
                int mx = (int)(mc.field_71417_B.func_198024_e() * (double)mc.func_228018_at_().func_198107_o() / (double)mc.func_228018_at_().func_198105_m());
                int my = (int)(mc.field_71417_B.func_198026_f() * (double)mc.func_228018_at_().func_198087_p() / (double)mc.func_228018_at_().func_198083_n());
                Style style = mc.field_71456_v.func_146158_b().func_238494_b_((double)mx, (double)my);
                if (style != null && style.func_150235_h() != null) {
                    newCursorType = CursorType.HAND;
                }
            }
            for (CursorType cursorType : cursors.keySet()) {
                if (cursorType.getCursorTester() == null || !cursorType.getCursorTester().testCursor(newCursorType, gui, ev.getMouseX(), ev.getMouseY(), ev.getRenderPartialTicks())) continue;
                newCursorType = cursorType;
                break;
            }
        }
        CursorMod.changeCursor(newCursorType);
        if (CursorMod.config.clickAnimation) {
            Iterator<CursorClick> iterator = cursorClicks.iterator();
            while (iterator.hasNext()) {
                CursorClick cursorClick = iterator.next();
                int posX = (int)cursorClick.getPosX();
                int posY = (int)cursorClick.getPosY();
                gui.getMinecraft().func_110434_K().func_110577_a(new ResourceLocation("textures/gui/click_" + (2 - cursorClick.getTime() / 3) + ".png"));
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                GuiUtils.drawScaledCustomSizeModalRect(posX - 8, posY - 8, 0.0f, 0.0f, 16, 16, 16, 16, 16.0f, 16.0f);
                cursorClick.descreaseTime();
                if (cursorClick.getTime() > 0) continue;
                iterator.remove();
            }
        }
    }

    @SubscribeEvent
    public void onGuiCloses(TickEvent ev) {
        if (!cursorClicks.isEmpty() && Minecraft.func_71410_x().field_71462_r == null) {
            cursorClicks.clear();
        }
    }

    @SubscribeEvent
    public void onGuiCloses(TickEvent.ClientTickEvent ev) {
        if (ev.phase == TickEvent.Phase.END) {
            this.checkModList(Minecraft.func_71410_x().field_71462_r);
        }
    }

    @SubscribeEvent
    public void onInitScreen(GuiScreenEvent.InitGuiEvent.Post ev) {
        CursorMod.forceNextCursor();
    }

    @SubscribeEvent
    public void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre ev) {
        if (ev.getButton() == 0 && CursorMod.config.clickAnimation) {
            cursorClicks.add(new CursorClick(6, ev.getMouseX(), ev.getMouseY()));
        }
    }

    private void setup(FMLLoadCompleteEvent ev) {
        config.sync(FMLPaths.CONFIGDIR.get().resolve("customcursormod.toml").toFile());
        cursors.values().forEach(CursorConfig::getCursor);
    }
}

