/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorMod;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiCursorConfig;
import fr.atesab.customcursormod.gui.GuiUtils;
import fr.atesab.customcursormod.gui.GuiValueButton;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiConfigCursorMod
extends Screen {
    private Screen parent;
    private Map<CursorType, CursorConfig> cursors;
    private List<GuiValueButton<CursorType>> cursorButtons = new ArrayList<GuiValueButton<CursorType>>();
    private Button lastPage;
    private Button nextPage;
    private int page = 0;
    private int elementByPage = 1;

    public GuiConfigCursorMod(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("cursormod.gui.cursorList"));
        this.parent = parent;
        this.cursors = CursorMod.getCursors();
    }

    private void defineButton() {
        if (this.lastPage != null) {
            boolean bl = this.lastPage.field_230693_o_ = this.page > 0;
        }
        if (this.nextPage != null) {
            this.nextPage.field_230693_o_ = this.page < this.cursors.size() / this.elementByPage;
        }
        for (int i = 0; i < this.cursorButtons.size(); ++i) {
            this.cursorButtons.get((int)i).field_230694_p_ = i < (this.page + 1) * this.elementByPage && i >= this.page * this.elementByPage;
        }
    }

    private void drawCursor(int posX, int posY, CursorConfig cursorConfig) {
        try {
            BufferedImage image = ImageIO.read(cursorConfig.getResource().func_199027_b());
            int imageWidth = image.getWidth();
            int imageHeight = image.getWidth();
            int numImage = image.getHeight() / image.getWidth();
            GuiUtils.drawGradientRect(this.func_230927_p_(), posX, posY, posX + 20, posY + 20, -1072689136, -804253680);
            this.getMinecraft().func_110434_K().func_110577_a(cursorConfig.getResourceLocation());
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtils.drawScaledCustomSizeModalRect(posX, posY, 0.0f, 0.0f, imageWidth, imageHeight, 20, 20, imageWidth, imageHeight * numImage);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        int n = this.field_230708_k_ / 2;
        int n2 = this.field_230709_l_ / 2;
        int n3 = (this.elementByPage / 2 + 1) * 21 + 2;
        this.field_230712_o_.getClass();
        GuiConfigCursorMod.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"Custom Cursor Mod v1.2.2", (int)n, (int)(n2 - (n3 + 9)), (int)Color.ORANGE.getRGB());
        for (int i = this.page * this.elementByPage; i < this.cursorButtons.size() && i < (this.page + 1) * this.elementByPage; ++i) {
            GuiValueButton<CursorType> button = this.cursorButtons.get(i);
            this.drawCursor(button.field_230690_l_ + button.func_230998_h_() + 1, button.field_230691_m_, this.cursors.get(button.getValue()));
        }
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void func_231160_c_() {
        this.page = 0;
        this.elementByPage = (this.field_230709_l_ - 63) / 21;
        if (this.elementByPage > 10) {
            this.elementByPage = 10;
        }
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 79, this.field_230709_l_ / 2 + this.elementByPage / 2 * 21, 158, 20, (ITextComponent)new TranslationTextComponent("gui.done"), b -> this.getMinecraft().func_147108_a(this.parent)));
        if (this.elementByPage <= this.cursors.size()) {
            this.lastPage = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + this.elementByPage / 2 * 21, 20, 20, (ITextComponent)new StringTextComponent("<"), b -> {
                --this.page;
                this.defineButton();
            }));
            this.nextPage = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 80, this.field_230709_l_ / 2 + this.elementByPage / 2 * 21, 20, 20, (ITextComponent)new StringTextComponent(">"), b -> {
                ++this.page;
                this.defineButton();
            }));
        } else {
            this.nextPage = null;
            this.lastPage = null;
        }
        int i = -1;
        this.cursorButtons.clear();
        for (Map.Entry<CursorType, CursorConfig> entry : this.cursors.entrySet()) {
            final CursorType type = entry.getKey();
            final CursorConfig cfg = entry.getValue();
            this.cursorButtons.add(new GuiValueButton<CursorType>(this.field_230708_k_ / 2 - 100, this.field_230709_l_ / 2 + (i++ % this.elementByPage - this.elementByPage / 2) * 21, 200, 20, type.getTranslation(), type){

                public void func_230930_b_() {
                    GuiConfigCursorMod.this.getMinecraft().func_147108_a((Screen)new GuiCursorConfig(GuiConfigCursorMod.this, type, cfg){

                        @Override
                        protected void saveConfig(CursorConfig cursorConfig) {
                            CursorMod.replaceCursor(type, cursorConfig);
                        }
                    });
                }
            });
        }
        this.field_230710_m_.addAll(this.cursorButtons);
        this.field_230705_e_.addAll(this.cursorButtons);
        this.defineButton();
        super.func_231160_c_();
    }
}

