/*
 * Decompiled with CFR 0.152.
 */
package fr.atesab.customcursormod.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import fr.atesab.customcursormod.CursorConfig;
import fr.atesab.customcursormod.CursorType;
import fr.atesab.customcursormod.gui.GuiSelectZone;
import fr.atesab.customcursormod.gui.GuiUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GuiCursorConfig
extends Screen {
    private static final ITextComponent EMPTY = new StringTextComponent("");
    private Screen parent;
    private TextFieldWidget xhotspot;
    private TextFieldWidget yhotspot;
    private TextFieldWidget cursorLocation;
    private Button doneButton;
    private GuiSelectZone selectZone;
    private int imageWidth = 1;
    private int imageHeight = 1;
    private int numImage = 1;
    private final CursorType type;
    private CursorConfig cursorConfig;

    public GuiCursorConfig(Screen parent, CursorType type, CursorConfig cursorConfig) {
        super((ITextComponent)new TranslationTextComponent("cursormod.gui.configCursor"));
        this.parent = parent;
        this.type = type;
        this.cursorConfig = cursorConfig.copy();
    }

    private void updateCursorValues(CursorConfig cursorConfig) {
        this.cursorConfig = cursorConfig;
        this.xhotspot.func_146180_a(String.valueOf(cursorConfig.getxHotSpot()));
        this.yhotspot.func_146180_a(String.valueOf(cursorConfig.getyHotSpot()));
        this.cursorLocation.func_146180_a(cursorConfig.getLink());
    }

    private void drawCenterString(MatrixStack stack, String text, int x, int y, int HEIGHT, int color) {
        float f = x - this.field_230712_o_.func_78256_a(text) / 2;
        int n = y + HEIGHT / 2;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_238405_a_(stack, text, f, (float)(n - 9 / 2), color);
    }

    private void drawRightString(MatrixStack stack, String text, int x, int y, int HEIGHT, int color) {
        float f = x - this.field_230712_o_.func_78256_a(text);
        int n = y + HEIGHT / 2;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_238405_a_(stack, text, f, (float)(n - 9 / 2), color);
    }

    public void func_230430_a_(MatrixStack stack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(stack);
        this.xhotspot.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.yhotspot.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.cursorLocation.func_230430_a_(stack, mouseX, mouseY, partialTicks);
        this.drawCenterString(stack, this.type.getName(), this.field_230708_k_ / 2 - 74, this.field_230709_l_ / 2 - 41 - 21, 20, Color.ORANGE.getRGB());
        this.drawRightString(stack, I18n.func_135052_a((String)"cursormod.config.xhotspot", (Object[])new Object[0]) + " : ", this.xhotspot.field_230690_l_, this.xhotspot.field_230691_m_, this.xhotspot.func_238483_d_(), Color.WHITE.getRGB());
        this.drawRightString(stack, I18n.func_135052_a((String)"cursormod.config.yhotspot", (Object[])new Object[0]) + " : ", this.yhotspot.field_230690_l_, this.yhotspot.field_230691_m_, this.yhotspot.func_238483_d_(), Color.WHITE.getRGB());
        this.drawRightString(stack, I18n.func_135052_a((String)"cursormod.config.location", (Object[])new Object[0]) + " : ", this.cursorLocation.field_230690_l_, this.cursorLocation.field_230691_m_, this.cursorLocation.func_238483_d_(), Color.WHITE.getRGB());
        if (this.syncImageSize()) {
            this.getMinecraft().func_110434_K().func_110577_a(this.cursorConfig.getResourceLocation());
            GuiUtils.drawGradientRect(this.func_230927_p_(), this.field_230708_k_ / 2 + 36, this.field_230709_l_ / 2 - 64, this.field_230708_k_ / 2 + 164, this.field_230709_l_ / 2 + 64, -1072689136, -804253680);
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            GuiUtils.drawScaledCustomSizeModalRect(this.field_230708_k_ / 2 + 36, this.field_230709_l_ / 2 - 64, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 128, 128, this.imageWidth, this.imageHeight * this.numImage);
            if (this.cursorConfig.getxHotSpot() >= 0 && this.cursorConfig.getxHotSpot() < this.imageWidth && this.cursorConfig.getyHotSpot() >= 0 && this.cursorConfig.getyHotSpot() < this.imageHeight) {
                int n = this.field_230708_k_ / 2 + 36 + (int)((float)this.cursorConfig.getxHotSpot() * 128.0f / (float)this.imageWidth);
                int n2 = this.field_230709_l_ / 2 - 64 + (int)((float)this.cursorConfig.getyHotSpot() * 128.0f / (float)this.imageHeight);
                this.field_230712_o_.getClass();
                GuiCursorConfig.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)"+", (int)n, (int)(n2 - 9 / 2), (int)Color.WHITE.getRGB());
            }
            if (this.numImage > 1) {
                GuiCursorConfig.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)("(" + I18n.func_135052_a((String)"cursormod.gui.animate", (Object[])new Object[0]) + ")"), (int)(this.field_230708_k_ / 2 + 100), (int)(this.field_230709_l_ / 2 + 64 + 1), (int)Color.WHITE.getRGB());
            }
            this.selectZone.enable = true;
        } else {
            String string = I18n.func_135052_a((String)"cursormod.gui.error", (Object[])new Object[0]);
            int n = this.field_230708_k_ / 2 + 100;
            int n3 = this.field_230709_l_ / 2;
            this.field_230712_o_.getClass();
            GuiCursorConfig.func_238471_a_((MatrixStack)stack, (FontRenderer)this.field_230712_o_, (String)string, (int)n, (int)(n3 - 9 / 2), (int)Color.RED.getRGB());
            this.selectZone.enable = false;
        }
        super.func_230430_a_(stack, mouseX, mouseY, partialTicks);
    }

    public void func_231160_c_() {
        this.syncImageSize();
        this.xhotspot = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 99, this.field_230709_l_ / 2 - 41, 124, 18, EMPTY);
        this.yhotspot = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 99, this.field_230709_l_ / 2 - 20, 124, 18, EMPTY);
        this.cursorLocation = new TextFieldWidget(this.field_230712_o_, this.field_230708_k_ / 2 - 99, this.field_230709_l_ / 2 + 1, 124, 18, EMPTY);
        this.cursorLocation.func_146203_f(Integer.MAX_VALUE);
        this.updateCursorValues(this.cursorConfig);
        this.selectZone = new GuiSelectZone(this.field_230708_k_ / 2 + 36, this.field_230709_l_ / 2 - 64, 128, 128);
        this.field_230705_e_.add(this.selectZone);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 174, this.field_230709_l_ / 2 + 21, 200, 20, (ITextComponent)new TranslationTextComponent("cursormod.gui.default"), b -> this.updateCursorValues(this.type.getDefaultConfig())));
        this.doneButton = new Button(this.field_230708_k_ / 2 - 174, this.field_230709_l_ / 2 + 42, 100, 20, (ITextComponent)new TranslationTextComponent("gui.done"), b -> {
            this.saveConfig(this.cursorConfig);
            this.getMinecraft().func_147108_a(this.parent);
        });
        this.func_230480_a_((Widget)this.doneButton);
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 72, this.field_230709_l_ / 2 + 42, 99, 20, (ITextComponent)new TranslationTextComponent("cursormod.gui.cancel"), b -> this.getMinecraft().func_147108_a(this.parent)));
        super.func_231160_c_();
    }

    public boolean func_231042_a_(char key, int modifier) {
        this.xhotspot.func_231042_a_(key, modifier);
        this.yhotspot.func_231042_a_(key, modifier);
        this.cursorLocation.func_231042_a_(key, modifier);
        return super.func_231042_a_(key, modifier);
    }

    public boolean func_231046_a_(int key, int scan, int modifier) {
        this.xhotspot.func_231046_a_(key, scan, modifier);
        this.yhotspot.func_231046_a_(key, scan, modifier);
        this.cursorLocation.func_231046_a_(key, scan, modifier);
        return super.func_231046_a_(key, scan, modifier);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        this.xhotspot.func_231044_a_(mouseX, mouseY, mouseButton);
        this.yhotspot.func_231044_a_(mouseX, mouseY, mouseButton);
        this.cursorLocation.func_231044_a_(mouseX, mouseY, mouseButton);
        if (mouseX >= (double)(this.field_230708_k_ / 2 + 36) && mouseY >= (double)(this.field_230709_l_ / 2 - 64) && mouseX <= (double)(this.field_230708_k_ / 2 + 164) && mouseY <= (double)(this.field_230709_l_ / 2 + 64)) {
            this.cursorConfig.setxHotSpot(MathHelper.func_76125_a((int)((int)((float)(mouseX - (double)(this.field_230708_k_ / 2 + 36)) * (float)this.imageWidth / 128.0f)), (int)0, (int)(this.imageWidth - 1)));
            this.cursorConfig.setyHotSpot(MathHelper.func_76125_a((int)((int)((float)(mouseY - (double)(this.field_230709_l_ / 2 - 64)) * (float)this.imageHeight / 128.0f)), (int)0, (int)(this.imageWidth - 1)));
            this.xhotspot.func_146180_a(String.valueOf(this.cursorConfig.getxHotSpot()));
            this.yhotspot.func_146180_a(String.valueOf(this.cursorConfig.getyHotSpot()));
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }

    protected abstract void saveConfig(CursorConfig var1);

    private boolean syncImageSize() {
        try {
            BufferedImage image = ImageIO.read(this.cursorConfig.getResource().func_199027_b());
            this.imageWidth = image.getWidth();
            this.imageHeight = image.getWidth();
            this.numImage = image.getHeight() / image.getWidth();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void func_231023_e_() {
        this.xhotspot.func_146178_a();
        this.yhotspot.func_146178_a();
        this.cursorLocation.func_146178_a();
        this.verifyValue();
        super.func_231023_e_();
    }

    private void verifyValue() {
        boolean flag = this.syncImageSize();
        try {
            this.cursorConfig.setxHotSpot(Integer.valueOf(this.xhotspot.func_146179_b()));
            if (this.cursorConfig.getxHotSpot() >= 0 && this.cursorConfig.getxHotSpot() < this.imageWidth) {
                this.xhotspot.func_146193_g(Color.WHITE.getRGB());
            } else {
                this.xhotspot.func_146193_g(Color.RED.getRGB());
                flag = false;
            }
        }
        catch (Exception e) {
            this.xhotspot.func_146193_g(Color.RED.getRGB());
            flag = false;
        }
        try {
            this.cursorConfig.setyHotSpot(Integer.valueOf(this.yhotspot.func_146179_b()));
            if (this.cursorConfig.getyHotSpot() >= 0 && this.cursorConfig.getyHotSpot() < this.imageHeight) {
                this.yhotspot.func_146193_g(Color.WHITE.getRGB());
            } else {
                this.yhotspot.func_146193_g(Color.RED.getRGB());
                flag = false;
            }
        }
        catch (Exception e) {
            this.yhotspot.func_146193_g(Color.RED.getRGB());
            flag = false;
        }
        this.cursorConfig.setLink(this.cursorLocation.func_146179_b());
        this.doneButton.field_230693_o_ = flag;
    }
}

