/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.Log;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.blocks.BlockGraveStone;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import de.maxhenkel.gravestone.util.NoSpaceException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

public class GraveProcessor {
    private EntityLivingBase entity;
    private World world;
    private BlockPos deathPosition;
    private BlockPos gravePosition;
    private List<ItemStack> drops;
    private long time;

    public GraveProcessor(EntityLivingBase entity) {
        this.entity = entity;
        this.world = entity.func_130014_f_();
        this.gravePosition = this.deathPosition = entity.func_180425_c();
        this.drops = new ArrayList<ItemStack>();
        this.time = System.currentTimeMillis();
    }

    public boolean placeGraveStone(Collection<EntityItem> drops) {
        for (EntityItem ei : drops) {
            this.drops.add(ei.func_92059_d());
        }
        try {
            this.gravePosition = this.getGraveStoneLocation();
        }
        catch (NoSpaceException e) {
            this.gravePosition = this.deathPosition;
            Log.i("Grave of '" + this.entity.func_200200_C_().func_150261_e() + "' cant be created (No space)");
            return false;
        }
        try {
            this.world.func_175656_a(this.gravePosition, (IBlockState)Main.graveStone.func_176223_P().func_206870_a((IProperty)BlockGraveStone.FACING, (Comparable)this.entity.func_174811_aO().func_176734_d()));
            if (this.isReplaceable(this.gravePosition.func_177977_b())) {
                this.world.func_175656_a(this.gravePosition.func_177977_b(), Blocks.field_150346_d.func_176223_P());
            }
        }
        catch (Exception e) {
            return false;
        }
        TileEntity tileentity = this.world.func_175625_s(this.gravePosition);
        if (tileentity == null || !(tileentity instanceof TileEntityGraveStone)) {
            return false;
        }
        try {
            TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)tileentity;
            graveTileEntity.setPlayerName(this.entity.func_200200_C_().func_150254_d());
            graveTileEntity.setPlayerUUID(this.entity.func_110124_au().toString());
            graveTileEntity.setDeathTime(this.time);
            graveTileEntity.setRenderHead(this.entity instanceof EntityPlayer);
            this.addItems(graveTileEntity, drops);
        }
        catch (Exception e) {
            Log.w("Failed to fill gravestone with data");
        }
        return true;
    }

    private void addItems(TileEntityGraveStone graveStone, Collection<EntityItem> items) {
        try {
            int i = 0;
            for (EntityItem item : items) {
                try {
                    ItemStack stack = item.func_92059_d();
                    if (graveStone.func_70302_i_() > i) {
                        graveStone.func_70299_a(i, stack);
                    } else {
                        InventoryHelper.func_180173_a((World)this.world, (double)graveStone.func_174877_v().func_177958_n(), (double)graveStone.func_174877_v().func_177956_o(), (double)graveStone.func_174877_v().func_177952_p(), (ItemStack)stack);
                    }
                }
                catch (Exception e) {
                    Log.w("Failed to add Item '" + item.func_92059_d().func_77973_b().func_77658_a() + "' to gravestone");
                }
                ++i;
            }
        }
        catch (Exception e) {
            Log.w("Failed to add Ites to gravestone");
        }
    }

    public BlockPos getGraveStoneLocation() throws NoSpaceException {
        BlockPos location = new BlockPos(this.deathPosition.func_177958_n(), this.deathPosition.func_177956_o(), this.deathPosition.func_177952_p());
        if (World.func_189509_E((BlockPos)location) && location.func_177956_o() < this.world.func_72800_K()) {
            location = new BlockPos(location.func_177958_n(), 1, location.func_177952_p());
        }
        while (location.func_177956_o() < this.world.func_72800_K()) {
            if (this.isReplaceable(location)) {
                return location;
            }
            location = location.func_177982_a(0, 1, 0);
        }
        throw new NoSpaceException("No free Block above death Location");
    }

    private boolean isReplaceable(BlockPos pos) {
        Block b = this.world.func_180495_p(pos).func_177230_c();
        if (this.world.func_175623_d(pos)) {
            return true;
        }
        for (Block replaceableBlock : Config.replaceableBlocks) {
            if (!b.getRegistryName().toString().equals(replaceableBlock.getRegistryName().toString())) continue;
            return true;
        }
        return false;
    }

    public void givePlayerNote() {
        if (!(this.entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)this.entity;
        DeathInfo info = new DeathInfo(this.gravePosition, DimensionType.func_212678_a((DimensionType)player.field_71093_bK).toString(), this.drops.stream().collect(Collectors.toList()), player.func_200200_C_().func_150261_e(), this.time, player.func_110124_au());
        ItemStack stack = new ItemStack((IItemProvider)Main.deathInfo);
        info.addToItemStack(stack);
        player.field_71071_by.func_70441_a(stack);
    }

    public EntityLivingBase getEntity() {
        return this.entity;
    }
}

