/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.blocks.BlockGraveStone;
import de.maxhenkel.gravestone.entity.EntityGhostPlayer;
import de.maxhenkel.gravestone.entity.RenderFactoryGhostPlayer;
import de.maxhenkel.gravestone.events.BlockEvents;
import de.maxhenkel.gravestone.events.DeathEvents;
import de.maxhenkel.gravestone.items.ItemDeathInfo;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import de.maxhenkel.gravestone.tileentity.TileEntitySpecialRendererGraveStone;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;

@Mod.EventBusSubscriber(modid="gravestone")
@Mod(value="gravestone")
public class Main {
    public static final String MODID = "gravestone";
    private static Main instance;
    @ObjectHolder(value="gravestone:gravestone")
    public static BlockGraveStone graveStone;
    @ObjectHolder(value="gravestone:gravestone")
    public static Item graveStoneItem;
    @ObjectHolder(value="gravestone:gravestone")
    public static TileEntityType<TileEntityGraveStone> graveTileEntity;
    @ObjectHolder(value="gravestone:death_info")
    public static ItemDeathInfo deathInfo;
    @ObjectHolder(value="gravestone:player_ghost")
    public static EntityType<EntityGhostPlayer> ghost;
    public static ResourceLocation ghostLootTable;

    public Main() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Block.class, this::registerBlocks);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, this::registerTileEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(EntityType.class, this::registerEntities);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::configEvent);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, Config.SERVER_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, Config.CLIENT_SPEC);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup));
    }

    @SubscribeEvent
    public void configEvent(ModConfig.ModConfigEvent event) {
        if (event.getConfig().getType() == ModConfig.Type.SERVER) {
            Config.loadServer();
        } else if (event.getConfig().getType() == ModConfig.Type.CLIENT) {
            Config.loadClient();
        }
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new DeathEvents());
        MinecraftForge.EVENT_BUS.register((Object)new BlockEvents());
        MinecraftForge.EVENT_BUS.register((Object)this);
        ghostLootTable = LootTableList.func_186375_a((ResourceLocation)new ResourceLocation(MODID, "entities/player_ghost"));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(EntityGhostPlayer.class, (IRenderFactory)new RenderFactoryGhostPlayer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityGraveStone.class, (TileEntityRenderer)new TileEntitySpecialRendererGraveStone());
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        Block[] blockArray = new Block[1];
        graveStone = new BlockGraveStone();
        blockArray[0] = graveStone;
        event.getRegistry().registerAll((IForgeRegistryEntry[])blockArray);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        Item[] itemArray = new Item[2];
        itemArray[0] = graveStoneItem = graveStone.toItem();
        deathInfo = new ItemDeathInfo();
        itemArray[1] = deathInfo;
        event.getRegistry().registerAll((IForgeRegistryEntry[])itemArray);
        Item.field_179220_a.put(graveStone, graveStoneItem);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        graveTileEntity = TileEntityType.func_200966_a((String)graveStone.getRegistryName().toString(), (TileEntityType.Builder)TileEntityType.Builder.func_200963_a(TileEntityGraveStone::new));
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        ghost = EntityType.func_200712_a((String)"gravestone:player_ghost", (EntityType.Builder)EntityType.Builder.func_201757_a(EntityGhostPlayer.class, EntityGhostPlayer::new));
    }
}

