/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.blocks;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import de.maxhenkel.gravestone.util.IItemBlock;
import de.maxhenkel.gravestone.util.Tools;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Fluids;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockGraveStone
extends Block
implements ITileEntityProvider,
IItemBlock,
IBucketPickupHandler,
ILiquidContainer {
    public static final DirectionProperty FACING = DirectionProperty.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final VoxelShape BASE1 = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape BASE2 = Block.func_208617_a((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final Map<EnumFacing, VoxelShape> SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)EnumFacing.NORTH, (Object)Tools.combine(BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0), Block.func_208617_a((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0), Block.func_208617_a((double)3.0, (double)14.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0)), (Object)EnumFacing.SOUTH, (Object)Tools.combine(BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)15.0, (double)15.0, (double)12.0, (double)14.0), Block.func_208617_a((double)2.0, (double)12.0, (double)15.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)3.0, (double)14.0, (double)15.0, (double)13.0, (double)15.0, (double)14.0)), (Object)EnumFacing.EAST, (Object)Tools.combine(BASE1, BASE2, Block.func_208617_a((double)15.0, (double)2.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0), Block.func_208617_a((double)15.0, (double)12.0, (double)2.0, (double)14.0, (double)14.0, (double)14.0), Block.func_208617_a((double)15.0, (double)14.0, (double)3.0, (double)14.0, (double)15.0, (double)13.0)), (Object)EnumFacing.WEST, (Object)Tools.combine(BASE1, BASE2, Block.func_208617_a((double)1.0, (double)2.0, (double)1.0, (double)2.0, (double)12.0, (double)15.0), Block.func_208617_a((double)1.0, (double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.func_208617_a((double)1.0, (double)14.0, (double)3.0, (double)2.0, (double)15.0, (double)13.0))));

    public BlockGraveStone() {
        super(Block.Properties.func_200949_a((Material)Material.field_151570_A, (MaterialColor)MaterialColor.field_151664_l).func_200948_a(0.3f, Float.MAX_VALUE));
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)EnumFacing.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("gravestone", "gravestone");
    }

    @Override
    public Item toItem() {
        return (Item)new ItemBlock((Block)this, new Item.Properties().func_200916_a(ItemGroup.field_78031_c)).setRegistryName(this.getRegistryName());
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING});
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, IBlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) == false && fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, IBlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)WATERLOGGED)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a((IWorldReaderBase)worldIn));
            }
            return true;
        }
        return false;
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void onBlockExploded(IBlockState state, World world, BlockPos pos, Explosion explosion) {
    }

    public void func_180652_a(World p_180652_1_, BlockPos p_180652_2_, Explosion p_180652_3_) {
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean doesSideBlockRendering(IBlockState state, IWorldReader world, BlockPos pos, EnumFacing face) {
        return false;
    }

    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return (IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)FACING, (Comparable)context.func_195992_f())).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockReader world, BlockPos pos) {
        return false;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockReader world, BlockPos pos, Entity entity) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean canSilkHarvest(IBlockState p_canSilkHarvest_1_, IWorldReader p_canSilkHarvest_2_, BlockPos p_canSilkHarvest_3_, EntityPlayer p_canSilkHarvest_4_) {
        return true;
    }

    protected ItemStack func_180643_i(IBlockState p_180643_1_) {
        return new ItemStack((IItemProvider)this);
    }

    public int func_196264_a(IBlockState p_196264_1_, Random p_196264_2_) {
        return 0;
    }

    public boolean func_196250_a(IBlockState state, World world, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing facing, float x, float y, float z) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity tileentity = world.func_175625_s(pos);
        if (!(tileentity instanceof TileEntityGraveStone)) {
            return true;
        }
        TileEntityGraveStone grave = (TileEntityGraveStone)tileentity;
        return this.displayGraveInfo(grave, player);
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof IInventory) {
                InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((IInventory)tileentity));
                worldIn.func_175666_e(pos, (Block)this);
            }
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    private boolean displayGraveInfo(TileEntityGraveStone grave, EntityPlayer player) {
        String name = grave.getPlayerName();
        String time = grave.getTimeString();
        if (name == null || name.isEmpty()) {
            return true;
        }
        if (time == null || time.isEmpty()) {
            player.func_145747_a((ITextComponent)new TextComponentString(name));
        } else {
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.died", new Object[]{name, time}));
        }
        return true;
    }

    public boolean func_196253_a(IBlockState p_196253_1_, BlockItemUseContext p_196253_2_) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockState state, IWorldReaderBase world, BlockPos pos) {
        return false;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockReader p_193383_1_, IBlockState p_193383_2_, BlockPos p_193383_3_, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader reader, BlockPos pos) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public VoxelShape func_196247_c(IBlockState state, IBlockReader reader, BlockPos pos) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader reader, BlockPos pos) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public VoxelShape func_199600_g(IBlockState state, IBlockReader reader, BlockPos pos) {
        return SHAPES.get(state.func_177229_b((IProperty)FACING));
    }

    public TileEntity func_196283_a_(IBlockReader iBlockReader) {
        return this.createTileEntity(this.func_176223_P(), iBlockReader);
    }

    public TileEntity createTileEntity(IBlockState state, IBlockReader world) {
        return new TileEntityGraveStone();
    }
}

