/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.entity;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.Main;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMoveTowardsRestriction;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class EntityGhostPlayer
extends EntityMob {
    private static final DataParameter<String> PLAYER_UUID = EntityDataManager.func_187226_a(EntityGhostPlayer.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityGhostPlayer(World world) {
        super(Main.ghost, world);
        this.func_70105_a(0.6f, 1.95f);
    }

    public EntityGhostPlayer(World world, UUID playerUUID, String playerName) {
        this(world);
        this.setPlayerUUID(playerUUID);
        this.func_200203_b((ITextComponent)new TextComponentString(playerName));
    }

    public boolean func_94059_bO() {
        return false;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIMoveTowardsRestriction((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        if (Config.friendlyGhost) {
            this.field_70715_bh.func_75776_a(10, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLiving.class, 10, false, true, (Predicate)new com.google.common.base.Predicate<EntityLiving>(){

                public boolean apply(@Nullable EntityLiving entityLiving) {
                    return entityLiving != null && IMob.field_175450_e.test(entityLiving) && !(entityLiving instanceof EntityCreeper) && !(entityLiving instanceof EntityGhostPlayer);
                }
            }));
        } else {
            this.field_70715_bh.func_75776_a(10, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.func_184212_Q().func_187214_a(PLAYER_UUID, (Object)new UUID(0L, 0L).toString());
    }

    public boolean func_70662_br() {
        return true;
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.UNDEAD;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return Main.ghostLootTable;
    }

    public void setPlayerUUID(UUID uuid) {
        this.func_184212_Q().func_187227_b(PLAYER_UUID, (Object)uuid.toString());
        if (uuid.toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            this.setOverpowered();
        }
    }

    private void setOverpowered() {
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(20.0);
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        if (name.func_150261_e().equals("henkelmax")) {
            this.setOverpowered();
        }
    }

    public UUID getPlayerUUID() {
        String uuidStr = (String)this.func_184212_Q().func_187225_a(PLAYER_UUID);
        UUID uuid = new UUID(0L, 0L);
        try {
            uuid = UUID.fromString(uuidStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return uuid;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74778_a("player_uuid", this.getPlayerUUID().toString());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("player_uuid")) {
            String uuidStr = compound.func_74779_i("player_uuid");
            try {
                UUID uuid = UUID.fromString(uuidStr);
                this.setPlayerUUID(uuid);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean func_70652_k(Entity entityIn) {
        if (entityIn.func_200200_C_().equals("henkelmax") || entityIn.func_110124_au().toString().equals("af3bd5f4-8634-4700-8281-e4cc851be180")) {
            return true;
        }
        return super.func_70652_k(entityIn);
    }
}

