/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.entity.EntityGhostPlayer;
import de.maxhenkel.gravestone.tileentity.TileEntityGraveStone;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gravestone")
public class BlockEvents {
    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        if (event.isCanceled()) {
            return;
        }
        IWorld world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        if (!event.getState().func_177230_c().equals(Main.graveStone)) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (!(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone graveTileEntity = (TileEntityGraveStone)te;
        ItemStack stack = player.func_184614_ca();
        if (!(stack != null && stack.func_77973_b().equals(Main.graveStoneItem) || (stack = player.func_184592_cb()) != null && stack.func_77973_b().equals(Main.graveStoneItem))) {
            return;
        }
        if (!stack.func_82837_s()) {
            return;
        }
        String name = stack.func_200301_q().func_150261_e();
        if (name == null) {
            return;
        }
        graveTileEntity.setPlayerName(name);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        IWorld world = event.getWorld();
        if (world.func_201670_d()) {
            return;
        }
        if (!event.getState().func_177230_c().equals(Main.graveStone)) {
            return;
        }
        if (!this.checkBreak(event)) {
            return;
        }
        this.removeDeathNote(event);
        this.spawnGhost(event);
    }

    private void spawnGhost(BlockEvent.BreakEvent event) {
        if (!Config.spawnGhost) {
            return;
        }
        IWorld iWorld = event.getWorld();
        if (!(iWorld instanceof World)) {
            return;
        }
        World world = (World)iWorld;
        if (!world.func_175623_d(event.getPos().func_177984_a())) {
            return;
        }
        TileEntity te = world.func_175625_s(event.getPos());
        if (te == null || !(te instanceof TileEntityGraveStone)) {
            return;
        }
        TileEntityGraveStone tileentity = (TileEntityGraveStone)te;
        UUID uuid = null;
        try {
            uuid = UUID.fromString(tileentity.getPlayerUUID());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (uuid == null) {
            return;
        }
        EntityGhostPlayer ghost = new EntityGhostPlayer(world, uuid, tileentity.getPlayerName());
        ghost.func_70107_b((double)event.getPos().func_177958_n() + 0.5, (double)event.getPos().func_177956_o() + 0.1, (double)event.getPos().func_177952_p() + 0.5);
        world.func_72838_d((Entity)ghost);
    }

    private void removeDeathNote(BlockEvent.BreakEvent event) {
        if (!Config.removeDeathNote) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        InventoryPlayer inv = player.field_71071_by;
        BlockPos pos = event.getPos();
        String dim = player.field_71093_bK.toString();
        for (ItemStack stack : inv.field_70462_a) {
            DeathInfo info;
            if (stack == null || !stack.func_77973_b().equals((Object)Main.deathInfo) || !stack.func_77942_o() || !stack.func_77978_p().func_74764_b("info") || (info = DeathInfo.fromNBT(stack.func_77978_p().func_74775_l("info"))) == null || !dim.equals(info.getDimension()) || !pos.equals((Object)info.getDeathLocation())) continue;
            inv.func_184437_d(stack);
        }
        for (ItemStack stack : inv.field_70460_b) {
            if (stack == null || !stack.func_77973_b().equals((Object)Main.deathInfo)) continue;
            inv.func_184437_d(stack);
        }
        for (ItemStack stack : inv.field_184439_c) {
            if (stack == null || !stack.func_77973_b().equals((Object)Main.deathInfo)) continue;
            inv.func_184437_d(stack);
        }
    }

    public boolean checkBreak(BlockEvent.BreakEvent event) {
        EntityPlayerMP p;
        boolean isOp;
        if (!Config.onlyOwnersCanBreak) {
            return true;
        }
        IWorld world = event.getWorld();
        EntityPlayer player = event.getPlayer();
        TileEntity te = world.func_175625_s(event.getPos());
        if (te == null || !(te instanceof TileEntityGraveStone)) {
            return true;
        }
        TileEntityGraveStone tileentity = (TileEntityGraveStone)te;
        if (player instanceof EntityPlayerMP && (isOp = (p = (EntityPlayerMP)player).func_211513_k(p.field_71133_b.func_110455_j()))) {
            return true;
        }
        String uuid = tileentity.getPlayerUUID();
        if (uuid == null) {
            return true;
        }
        if (player.func_110124_au().toString().equals(uuid)) {
            return true;
        }
        event.setCanceled(true);
        return false;
    }
}

