/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.GraveProcessor;
import de.maxhenkel.gravestone.Log;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.util.Tools;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class DeathEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!Config.giveDeathNotes) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (Tools.keepInventory(event.getEntityPlayer())) {
            return;
        }
        for (ItemStack stack : event.getOriginal().field_71071_by.field_70462_a) {
            if (!DeathInfo.isDeathInfoItem(stack)) continue;
            event.getEntityPlayer().field_71071_by.func_70441_a(stack);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityLivingBase)) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer) && !Config.livingGraves) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        try {
            EntityLivingBase entity = (EntityLivingBase)event.getEntity();
            GraveProcessor graveProcessor = new GraveProcessor(entity);
            Collection drops = event.getDrops();
            if (graveProcessor.placeGraveStone(drops)) {
                drops.clear();
            } else if (entity instanceof EntityPlayerMP) {
                String modname = new TextComponentTranslation("message.name", new Object[0]).func_150254_d();
                String message = new TextComponentTranslation("message.create_grave_failed", new Object[0]).func_150254_d();
                EntityPlayerMP player = (EntityPlayerMP)entity;
                player.func_145747_a((ITextComponent)new TextComponentString("[" + modname + "] " + message));
            }
            if (Config.giveDeathNotes) {
                graveProcessor.givePlayerNote();
            }
        }
        catch (Exception e) {
            Log.w("Failed to process death of '" + event.getEntity().func_200200_C_().func_150261_e() + "'");
            e.printStackTrace();
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDeathEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!Config.giveDeathNotes) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        EntityPlayer player = (EntityPlayer)event.getEntity();
        if (!Tools.keepInventory(player)) {
            return;
        }
        try {
            DeathInfo info = new DeathInfo(player.func_180425_c(), DimensionType.func_212678_a((DimensionType)player.field_71093_bK).toString(), new ArrayList<ItemStack>(), player.func_200200_C_().func_150261_e(), System.currentTimeMillis(), player.func_110124_au());
            ItemStack stack = new ItemStack((IItemProvider)Main.deathInfo);
            info.addToItemStack(stack);
            player.field_71071_by.func_70441_a(stack);
        }
        catch (Exception e) {
            Log.w("Failed to give player '" + player.func_200200_C_().func_150261_e() + "' death note");
        }
    }
}

