/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.gui;

import com.mojang.authlib.GameProfile;
import de.maxhenkel.gravestone.DeathInfo;
import de.maxhenkel.gravestone.gui.PageList;
import de.maxhenkel.gravestone.util.Tools;
import net.minecraft.client.entity.EntityOtherPlayerMP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class GUIDeathItems
extends GuiScreen {
    private static final ResourceLocation GUI_TEXTURE = new ResourceLocation("gravestone", "textures/gui/info.png");
    private static final int TEXTURE_X = 163;
    private static final int TEXTURE_Y = 165;
    private DeathInfo info;
    private GuiButton buttonPrev;
    private GuiButton buttonNext;
    private int page;
    private PageList pageList;

    public GUIDeathItems(DeathInfo info) {
        this.info = info;
        this.page = 0;
        this.pageList = new PageList(info.getItems(), this);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        int left = (this.field_146294_l - 163) / 2;
        this.buttonPrev = this.func_189646_b(new GuiButton(0, left, 190, 75, 20, new TextComponentTranslation("button.prev", new Object[0]).func_150254_d()){

            public void func_194829_a(double x, double y) {
                super.func_194829_a(x, y);
                GUIDeathItems.this.page--;
                if (GUIDeathItems.this.page < 0) {
                    GUIDeathItems.this.page = 0;
                }
                GUIDeathItems.this.checkButtons();
            }
        });
        this.buttonNext = this.func_189646_b(new GuiButton(1, left + 163 - 75, 190, 75, 20, new TextComponentTranslation("button.next", new Object[0]).func_150254_d()){

            public void func_194829_a(double x, double y) {
                super.func_194829_a(x, y);
                GUIDeathItems.this.page++;
                if (GUIDeathItems.this.page > GUIDeathItems.this.pageList.getPages()) {
                    GUIDeathItems.this.page = GUIDeathItems.this.pageList.getPages();
                }
                GUIDeathItems.this.checkButtons();
            }
        });
        this.buttonPrev.field_146124_l = false;
        if (this.pageList.getPages() <= 0) {
            this.buttonNext.field_146124_l = false;
        }
    }

    protected void checkButtons() {
        this.buttonPrev.field_146124_l = this.page > 0;
        this.buttonNext.field_146124_l = this.page < this.pageList.getPages();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        int left = (this.field_146294_l - 163) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(GUI_TEXTURE);
        this.func_73729_b(left, 20, 0, 0, 163, 165);
        if (this.page == 0) {
            this.drawFirstPage(mouseX, mouseY);
        } else if (this.page > 0 && this.pageList.getPages() >= this.page - 1) {
            this.pageList.drawPage(this.page - 1);
        }
    }

    public void drawFirstPage(int mouseX, int mouseY) {
        String title = new TextComponentTranslation("gui.deathinfo.title", new Object[0]).func_150254_d();
        int titleWidth = this.field_146289_q.func_78256_a(title);
        this.field_146289_q.func_211126_b(TextFormatting.BLACK + "" + TextFormatting.UNDERLINE + title, (float)((this.field_146294_l - titleWidth) / 2), 30.0f, 0);
        String textName = new TextComponentTranslation("gui.deathinfo.name", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.BLACK + textName, 50);
        String name = this.info.getName();
        this.drawRight(TextFormatting.DARK_GRAY + name, 50);
        String textDimension = new TextComponentTranslation("gui.deathinfo.dimension", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.BLACK + textDimension, 63);
        String dimension = Tools.translateDimension(this.info.getDimension());
        this.drawRight(TextFormatting.DARK_GRAY + dimension, 63);
        String textTime = new TextComponentTranslation("gui.deathinfo.time", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.BLACK + textTime, 76);
        String time = Tools.timeToString(this.info.getTime());
        this.drawRight(TextFormatting.DARK_GRAY + time, 76);
        String textLocation = new TextComponentTranslation("gui.deathinfo.location", new Object[0]).func_150254_d() + ":";
        this.drawLeft(TextFormatting.BLACK + textLocation, 89);
        String locX = "X: " + this.info.getDeathLocation().func_177958_n();
        String locY = "Y: " + this.info.getDeathLocation().func_177956_o();
        String locZ = "Z: " + this.info.getDeathLocation().func_177952_p();
        this.drawRight(TextFormatting.DARK_GRAY + locX, 89);
        this.drawRight(TextFormatting.DARK_GRAY + locY, 102);
        this.drawRight(TextFormatting.DARK_GRAY + locZ, 115);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        EntityOtherPlayerMP player = new EntityOtherPlayerMP((World)this.field_146297_k.field_71441_e, new GameProfile(this.info.getUuid(), this.info.getName()));
        GuiInventory.func_147046_a((int)(this.field_146294_l / 2), (int)175, (int)30, (float)(this.field_146294_l / 2 - mouseX), (float)(100 - mouseY), (EntityLivingBase)player);
    }

    public void drawItem(String string, int height) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 40;
        int offsetLeft = left + offset;
        this.field_146289_q.func_211126_b(string, (float)offsetLeft, (float)height, 0);
    }

    public void drawItemSize(String string, int height) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 15;
        int offsetLeft = left + offset;
        this.field_146289_q.func_211126_b(string, (float)offsetLeft, (float)height, 0);
    }

    public void drawLeft(String string, int height) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 7;
        int offsetLeft = left + offset;
        this.field_146289_q.func_211126_b(string, (float)offsetLeft, (float)height, 0);
    }

    public void drawRight(String string, int height) {
        int left = (this.field_146294_l - 163) / 2;
        int offset = 14;
        int strWidth = this.field_146289_q.func_78256_a(string);
        this.field_146289_q.func_211126_b(string, (float)(left + 163 - strWidth - offset), (float)height, 0);
    }

    public FontRenderer getFontRenderer() {
        return this.field_146289_q;
    }
}

