/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.util.Tools;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class Config {
    public static final ServerConfig SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ClientConfig CLIENT;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static Map<String, String> dimensionNames;
    public static String dateFormat;
    public static boolean renderSkull;
    public static boolean livingGraves;
    public static boolean giveDeathNotes;
    public static List<Block> replaceableBlocks;
    public static boolean removeDeathNote;
    public static boolean onlyOwnersCanBreak;
    public static boolean spawnGhost;
    public static boolean friendlyGhost;
    public static int graveTextColor;

    public static void loadServer() {
        livingGraves = (Boolean)Config.SERVER.livingGraves.get();
        giveDeathNotes = (Boolean)Config.SERVER.giveDeathNotes.get();
        replaceableBlocks = ((List)Config.SERVER.replaceableBlocks.get()).stream().map(s -> Tools.getBlock(s)).collect(Collectors.toList());
        removeDeathNote = (Boolean)Config.SERVER.removeDeathNote.get();
        onlyOwnersCanBreak = (Boolean)Config.SERVER.onlyOwnersCanBreak.get();
        spawnGhost = (Boolean)Config.SERVER.spawnGhost.get();
        friendlyGhost = (Boolean)Config.SERVER.friendlyGhost.get();
    }

    public static void loadClient() {
        dimensionNames = ((List)Config.CLIENT.dimensionNames.get()).stream().collect(Collectors.toMap(s -> s.split("=")[0], s -> s.split("=")[1]));
        dateFormat = (String)Config.CLIENT.dateFormat.get();
        renderSkull = (Boolean)Config.CLIENT.renderSkull.get();
        graveTextColor = Integer.parseInt((String)Config.CLIENT.graveTextColor.get(), 16);
    }

    static {
        Pair specPairServer = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPairServer.getRight();
        SERVER = (ServerConfig)specPairServer.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (ClientConfig)specPairClient.getLeft();
        dimensionNames = new HashMap<String, String>();
        dateFormat = "yyyy/MM/dd HH:mm:ss";
        renderSkull = true;
        livingGraves = false;
        giveDeathNotes = true;
        replaceableBlocks = new ArrayList<Block>();
        removeDeathNote = false;
        onlyOwnersCanBreak = false;
        spawnGhost = false;
        friendlyGhost = true;
        graveTextColor = 0xFFFFFF;
    }

    public static class ClientConfig {
        public ForgeConfigSpec.ConfigValue<List<String>> dimensionNames;
        public ForgeConfigSpec.ConfigValue<String> dateFormat;
        public ForgeConfigSpec.BooleanValue renderSkull;
        public ForgeConfigSpec.ConfigValue<String> graveTextColor;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.dimensionNames = builder.comment("The names of the Dimensions for the Death Note").translation("dimension_names").define("dimension_names", Arrays.asList("minecraft:overworld=Overworld", "minecraft:nether=Nether", "minecraft:the_end=The End"));
            this.dateFormat = builder.comment("The date format outputted by clicking the gravestone or displayed in the death note").translation("grave_date_format").define("grave_date_format", (Object)"yyyy/MM/dd HH:mm:ss");
            this.renderSkull = builder.comment("If this is set to true the players head will be rendered on the gravestone when there is a full block under it").translation("render_skull").define("render_skull", true);
            this.graveTextColor = builder.comment("The color of the text at the gravestone (Hex RGB)").translation("grave_text_color").define("grave_text_color", (Object)"FFFFFF");
        }
    }

    public static class ServerConfig {
        public ForgeConfigSpec.BooleanValue livingGraves;
        public ForgeConfigSpec.BooleanValue giveDeathNotes;
        public ForgeConfigSpec.ConfigValue<List<? extends String>> replaceableBlocks;
        public ForgeConfigSpec.BooleanValue removeDeathNote;
        public ForgeConfigSpec.BooleanValue onlyOwnersCanBreak;
        public ForgeConfigSpec.BooleanValue spawnGhost;
        public ForgeConfigSpec.BooleanValue friendlyGhost;

        public ServerConfig(ForgeConfigSpec.Builder builder) {
            this.livingGraves = builder.comment("If this is set to true every living entity will generate a gravestone").translation("enable_living_entity_graves").define("enable_living_entity_graves", false);
            this.giveDeathNotes = builder.comment("If this is set to true you get a death note after you died").translation("enable_death_note").define("enable_death_note", true);
            this.replaceableBlocks = builder.comment("The blocks that can be replaced with a grave when someone dies there").translation("replaceable_blocks").defineList("replaceable_blocks", Arrays.asList("minecraft:tall_grass", "minecraft:grass", "minecraft:water", "minecraft:lava", "minecraft:dandelion", "minecraft:lilac", "minecraft:rose_bush", "minecraft:peony", "minecraft:sunflower", "minecraft:poppy", "minecraft:blue_orchid", "minecraft:azure_bluet", "minecraft:oxeye_daisy", "minecraft:orange_tulip", "minecraft:pink_tulip", "minecraft:red_tulip", "minecraft:white_tulip", "minecraft:allium", "minecraft:fern", "minecraft:large_fern", "minecraft:spruce_sapling", "minecraft:acacia_sapling", "minecraft:birch_sapling", "minecraft:dark_oak_sapling", "minecraft:jungle_sapling", "minecraft:oak_sapling", "minecraft:brown_mushroom", "minecraft:red_mushroom", "minecraft:snow", "minecraft:vine", "minecraft:dead_bush", "minecraft:fire"), Objects::nonNull);
            this.removeDeathNote = builder.comment("If this is set to true the death note will be taken out of your inventory when you destroyed the gravestone").translation("remove_death_note").define("remove_death_note", false);
            this.onlyOwnersCanBreak = builder.comment("If this is set to true only the player that owns the gravestone and the admins can break the gravestone").translation("only_owners_can_break").define("only_owners_can_break", false);
            this.spawnGhost = builder.comment("If this is set to true a ghost of the dead player will be spawned when the gravestone is broken").translation("spawn_ghost").define("spawn_ghost", false);
            this.friendlyGhost = builder.comment("If this is set to true the ghost of the dead player will defend him").translation("friendly_ghost").define("friendly_ghost", true);
        }
    }
}

