/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import com.google.common.base.Predicate;
import de.maxhenkel.gravestone.TileEntityGraveStone;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGraveStone
extends BlockContainer {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockGraveStone() {
        super(new Material(MapColor.field_151664_l));
        String name = "gravestone";
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149663_c(name);
        this.setRegistryName("gravestone", name);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149711_c(0.3f);
        this.func_149752_b(Float.MAX_VALUE);
        this.field_149783_u = true;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_176225_a(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumFacing = EnumFacing.func_82600_a((int)meta);
        if (enumFacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumFacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)enumFacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    protected BlockState func_180661_e() {
        return new BlockState((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180654_a(IBlockAccess worldIn, BlockPos pos) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.11f, 1.0f);
    }

    public boolean canEntityDestroy(IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityGraveStone();
    }

    public int func_149645_b() {
        return 3;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityGraveStone) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)((TileEntityGraveStone)tileentity));
            worldIn.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (tileentity instanceof TileEntityGraveStone) {
            TileEntityGraveStone grave = (TileEntityGraveStone)tileentity;
            String name = grave.getPlayerName();
            String time = grave.getTimeString();
            if (name == null || name.isEmpty()) {
                return true;
            }
            if (time == null || time.isEmpty()) {
                playerIn.func_145747_a((IChatComponent)new ChatComponentTranslation(name, new Object[0]));
            } else {
                String msg = name + " " + new ChatComponentTranslation("message.died", new Object[0]).func_150254_d() + " " + time;
                playerIn.func_145747_a((IChatComponent)new ChatComponentTranslation(msg, new Object[0]));
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, side, hitX, hitY, hitZ);
    }

    public boolean canPlaceTorchOnTop(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_176200_f(World worldIn, BlockPos pos) {
        return false;
    }
}

