/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import net.minecraft.util.BlockPos;
import net.minecraftforge.common.DimensionManager;

public class DeathLocation {
    private BlockPos blockPos;
    private int dimID;

    public DeathLocation(BlockPos blockPos, int dimID) {
        this.blockPos = blockPos;
        this.dimID = dimID;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public int getDimID() {
        return this.dimID;
    }

    public void writeToFile(File file) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(String.valueOf(this.blockPos.func_177958_n()) + "\n");
            writer.write(String.valueOf(this.blockPos.func_177956_o()) + "\n");
            writer.write(String.valueOf(this.blockPos.func_177952_p()) + "\n");
            writer.write(String.valueOf(this.dimID) + "\n");
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DeathLocation readFromFile(File file) {
        if (!file.exists()) {
            return null;
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int x = Integer.parseInt(reader.readLine());
            int y = Integer.parseInt(reader.readLine());
            int z = Integer.parseInt(reader.readLine());
            int dimID = Integer.parseInt(reader.readLine());
            reader.close();
            return new DeathLocation(new BlockPos(x, y, z), dimID);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String dimIDToString(int id) {
        switch (id) {
            case -1: {
                return "Nether";
            }
            case 0: {
                return "Overworld";
            }
            case 1: {
                return "The End";
            }
        }
        String name = "";
        try {
            name = DimensionManager.getWorld((int)id).func_72912_H().func_76065_j();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public String toString() {
        return "X: " + this.blockPos.func_177958_n() + " Y: " + this.blockPos.func_177956_o() + " Z: " + this.blockPos.func_177952_p() + " (" + DeathLocation.dimIDToString(this.dimID) + ")";
    }
}

