/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.DeathLocation;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;

public class DeathLocationManager {
    private Map<String, DeathLocation> deathLocations = new HashMap<String, DeathLocation>();

    public boolean hasPos(EntityPlayer player) {
        String uuid = player.func_110124_au().toString();
        return this.deathLocations.containsKey(uuid);
    }

    public DeathLocation getPos(EntityPlayer player) {
        String uuid = player.func_110124_au().toString();
        return this.deathLocations.get(uuid);
    }

    public DeathLocation getPos(String uuid) {
        return this.deathLocations.get(uuid);
    }

    public void putPos(EntityPlayer player, DeathLocation location) {
        this.deathLocations.put(player.func_110124_au().toString(), location);
    }

    public void putPos(EntityPlayer player) {
        this.deathLocations.put(player.func_110124_au().toString(), new DeathLocation(player.func_180425_c(), player.field_71093_bK));
    }

    public void loadPlayer(EntityPlayer player, File file) {
        if (!file.exists()) {
            return;
        }
        DeathLocation loc = DeathLocation.readFromFile(file);
        if (loc != null) {
            this.deathLocations.put(player.func_110124_au().toString(), loc);
        }
    }

    public void savePlayer(EntityPlayer player, File file) {
        DeathLocation loc = this.getPos(player);
        if (loc != null) {
            loc.writeToFile(file);
        }
    }
}

