/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.DeathLocationManager;
import de.maxhenkel.gravestone.DeathPosition;
import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.UpdateChecker;
import java.io.File;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class Events {
    public static final String POS_SUFFIX = "deathpos";
    private boolean checkUpdates = false;
    private DeathLocationManager deathLocationManager = new DeathLocationManager();
    private boolean updateShown = false;

    public Events() {
        try {
            Main.getInstance().getConfig().load();
            this.checkUpdates = Main.getInstance().getConfig().get("gravestone", "check_updates", true).getBoolean();
            Main.getInstance().getConfig().save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerLoad(PlayerEvent.LoadFromFile event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        File userFile = event.getPlayerFile(POS_SUFFIX);
        this.deathLocationManager.loadPlayer(event.entityPlayer, userFile);
    }

    @SubscribeEvent
    public void playerSave(PlayerEvent.SaveToFile event) {
        if (event.isCanceled()) {
            return;
        }
        if (event.entityPlayer.field_70170_p.field_72995_K) {
            return;
        }
        File userFile = event.getPlayerFile(POS_SUFFIX);
        this.deathLocationManager.savePlayer(event.entityPlayer, userFile);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void playerDeath(LivingDropsEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        if (event.entity.field_70170_p.field_72995_K) {
            return;
        }
        try {
            event.setCanceled(true);
            List drops = event.drops;
            EntityPlayer player = (EntityPlayer)event.entity;
            DeathPosition deathPos = new DeathPosition(player);
            deathPos.placeGraveStone(drops);
            this.deathLocationManager.putPos(player);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.entity instanceof EntityPlayer)) {
            return;
        }
        final EntityPlayer player = (EntityPlayer)event.entity;
        if (!player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.field_70128_L) {
            return;
        }
        if (!this.checkUpdates) {
            return;
        }
        if (this.updateShown) {
            return;
        }
        UpdateChecker checker = new UpdateChecker(new UpdateChecker.IUpdateCheckResult(){

            @Override
            public void onResult(boolean isAvailable) {
                if (isAvailable) {
                    String msg = "[" + new ChatComponentTranslation("message.name", new Object[0]).func_150254_d() + "] " + new ChatComponentTranslation("message.update", new Object[0]).func_150254_d() + " ";
                    ClickEvent openUrl = new ClickEvent(ClickEvent.Action.OPEN_URL, "http://minecraft.curseforge.com/projects/gravestone-mod");
                    ChatStyle style = new ChatStyle();
                    style.func_150241_a(openUrl);
                    style.func_150228_d(Boolean.valueOf(true));
                    style.func_150238_a(EnumChatFormatting.GREEN);
                    style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(new ChatComponentTranslation("message.update.hover", new Object[0]).func_150254_d())));
                    ChatComponentText comp = new ChatComponentText("[Download]");
                    comp.func_150255_a(style);
                    player.func_145747_a(new ChatComponentText(msg).func_150257_a((IChatComponent)comp));
                }
            }
        }, 15, "http://maxhenkel.de/update/gravestone_1.8.9.txt");
        checker.start();
        this.updateShown = true;
    }

    public DeathLocationManager getDeathLocationManager() {
        return this.deathLocationManager;
    }
}

