/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.MItems;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;

public class DeathInfo {
    public static final String KEY_INFO = "info";
    public static final String KEY_POS_X = "pos_x";
    public static final String KEY_POS_Y = "pos_y";
    public static final String KEY_POS_Z = "pos_z";
    public static final String KEY_DIM = "dim";
    public static final String KEY_TIME = "time";
    public static final String KEY_ITEMS = "items";
    public static final String KEY_NAME = "name";
    private BlockPos deathLocation;
    private int dimension;
    private ItemInfo[] items;
    private String name;
    private long time;

    public DeathInfo(BlockPos deathLocation, int dimension, ItemInfo[] items, String name, long time) {
        this.deathLocation = deathLocation;
        this.dimension = dimension;
        this.items = items;
        this.name = name;
        this.time = time;
    }

    public BlockPos getDeathLocation() {
        return this.deathLocation;
    }

    public int getDimension() {
        return this.dimension;
    }

    public ItemInfo[] getItems() {
        return this.items;
    }

    public String getName() {
        return this.name;
    }

    public long getTime() {
        return this.time;
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a(KEY_POS_X, this.deathLocation.func_177958_n());
        compound.func_74768_a(KEY_POS_Y, this.deathLocation.func_177956_o());
        compound.func_74768_a(KEY_POS_Z, this.deathLocation.func_177952_p());
        compound.func_74768_a(KEY_DIM, this.dimension);
        compound.func_74778_a(KEY_NAME, this.name);
        compound.func_74772_a(KEY_TIME, this.time);
        NBTTagList itemList = new NBTTagList();
        for (ItemInfo s : this.items) {
            itemList.func_74742_a((NBTBase)s.toNBT());
        }
        compound.func_74782_a(KEY_ITEMS, (NBTBase)itemList);
        return compound;
    }

    public void addToItemStack(ItemStack stack) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a(KEY_INFO, (NBTBase)this.toNBT());
        stack.func_77982_d(compound);
    }

    public static DeathInfo fromNBT(NBTTagCompound compound) {
        int x = compound.func_74762_e(KEY_POS_X);
        int y = compound.func_74762_e(KEY_POS_Y);
        int z = compound.func_74762_e(KEY_POS_Z);
        BlockPos deathLocation = new BlockPos(x, y, z);
        int dimension = compound.func_74762_e(KEY_DIM);
        String name = compound.func_74779_i(KEY_NAME);
        long time = compound.func_74763_f(KEY_TIME);
        NBTTagList itemList = (NBTTagList)compound.func_74781_a(KEY_ITEMS);
        ItemInfo[] items = new ItemInfo[itemList.func_74745_c()];
        for (int i = 0; i < itemList.func_74745_c(); ++i) {
            NBTTagCompound s = itemList.func_150305_b(i);
            items[i] = ItemInfo.fromNBT(s);
        }
        return new DeathInfo(deathLocation, dimension, items, name, time);
    }

    public static DeathInfo getDeathInfoFromPlayerHand(EntityPlayer player) {
        ItemStack stack = null;
        if (DeathInfo.isDeathInfoItem(player.func_184614_ca().func_77973_b())) {
            stack = player.func_184614_ca();
        } else if (DeathInfo.isDeathInfoItem(player.func_184592_cb().func_77973_b())) {
            stack = player.func_184592_cb();
        } else {
            return null;
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound compound = stack.func_77978_p();
        if (!compound.func_74764_b(KEY_INFO)) {
            return null;
        }
        NBTTagCompound info = compound.func_74775_l(KEY_INFO);
        if (info == null) {
            return null;
        }
        return DeathInfo.fromNBT(info);
    }

    public static boolean isDeathInfoItem(Item item) {
        if (item == null) {
            return false;
        }
        return MItems.DEATH_INFO.equals(item);
    }

    public static boolean isDeathInfoItem(ItemStack item) {
        if (item == null) {
            return false;
        }
        return DeathInfo.isDeathInfoItem(item.func_77973_b());
    }

    public static class ItemInfo {
        public static final String KEY_NAME = "name";
        public static final String KEY_STACK_SIZE = "stacksize";
        private String name;
        private int stackSize;

        public ItemInfo(String name, int stackSize) {
            this.name = name;
            this.stackSize = stackSize;
        }

        public String getName() {
            return this.name;
        }

        public int getStackSize() {
            return this.stackSize;
        }

        public NBTTagCompound toNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("name", this.name);
            compound.func_74768_a(KEY_STACK_SIZE, this.stackSize);
            return compound;
        }

        public static ItemInfo fromNBT(NBTTagCompound compound) {
            return new ItemInfo(compound.func_74779_i("name"), compound.func_74762_e(KEY_STACK_SIZE));
        }
    }
}

