/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.Config;
import de.maxhenkel.gravestone.util.UpdateChecker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class UpdateCheckEvents {
    private boolean checkUpdates = Config.checkUpdates;
    private boolean updateShown = false;

    @SubscribeEvent
    public void playerJoin(EntityJoinWorldEvent event) {
        if (event.isCanceled()) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayer)) {
            return;
        }
        if (!event.getWorld().field_72995_K) {
            return;
        }
        final EntityPlayer player = (EntityPlayer)event.getEntity();
        if (player.field_70128_L) {
            return;
        }
        if (!this.checkUpdates) {
            return;
        }
        if (this.updateShown) {
            return;
        }
        UpdateChecker checker = new UpdateChecker(new UpdateChecker.IUpdateCheckResult(){

            @Override
            public void onResult(boolean isAvailable, String updateURL) {
                if (isAvailable) {
                    UpdateCheckEvents.this.showUpdateMessage(player, updateURL);
                }
            }
        }, 28, "http://maxhenkel.de/update/gravestone_1.11.2.txt");
        checker.start();
        this.updateShown = true;
    }

    private void showUpdateMessage(EntityPlayer player, String updateURL) {
        String modname = new TextComponentTranslation("message.name", new Object[0]).func_150254_d();
        String updateMessgae = new TextComponentTranslation("message.update", new Object[0]).func_150254_d();
        TextComponentTranslation hoverMessgae = new TextComponentTranslation("message.update.hover", new Object[0]);
        TextComponentTranslation download = new TextComponentTranslation("message.download", new Object[0]);
        String msg = "[" + modname + "] " + updateMessgae + " ";
        ClickEvent openUrl = new ClickEvent(ClickEvent.Action.OPEN_URL, updateURL);
        Style style = new Style();
        style.func_150241_a(openUrl);
        style.func_150228_d(Boolean.valueOf(true));
        style.func_150238_a(TextFormatting.GREEN);
        style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hoverMessgae));
        download.func_150255_a(style);
        player.func_145747_a(new TextComponentString(msg).func_150257_a((ITextComponent)download));
    }
}

