/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.bees.common.block;

import growthcraft.bees.shared.init.GrowthcraftBeesItems;
import growthcraft.core.shared.block.BlockUtils;
import growthcraft.core.shared.block.GrowthcraftRotatableBlockContainer;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAir;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBeeHive
extends GrowthcraftRotatableBlockContainer {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public BlockBeeHive(String unlocalizedName) {
        super(Material.field_151575_d);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_bees", unlocalizedName));
        this.setHarvestLevel("axe", 1);
        this.func_149675_a(true);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return GrowthcraftBeesItems.bee.getItem();
    }

    public int func_149679_a(int fortune, Random random) {
        return MathHelper.func_76125_a((int)(this.func_149745_a(random) + random.nextInt(fortune + 1)), (int)0, (int)2);
    }

    public int func_149745_a(Random random) {
        int i = random.nextInt(5);
        return i == 0 ? 1 : i;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        IBlockState upState;
        if (!worldIn.field_72995_K && (upState = worldIn.func_180495_p(pos.func_177984_a())).func_177230_c() instanceof BlockAir) {
            this.func_176226_b(worldIn, pos, state, 0);
            worldIn.func_175698_g(pos);
        }
        super.func_180650_b(worldIn, pos, state, rand);
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        if (world instanceof World) {
            this.func_180650_b((World)world, pos, world.func_180495_p(pos), this.rand);
        }
        super.onNeighborChange(world, pos, neighbor);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockBeeHive.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean isRotatable(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected void setDefaultDirection(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            EnumFacing facing = BlockUtils.getDefaultDirection(world, pos, state);
            world.func_180501_a(pos, state.func_177226_a((IProperty)TYPE_ROTATION, (Comparable)facing), 3);
        }
    }

    protected EnumFacing setOrientWhenPlacing(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer) {
        EnumFacing facing = EnumFacing.func_176733_a((double)placer.field_70177_z);
        worldIn.func_180501_a(pos, state.func_177226_a((IProperty)TYPE_ROTATION, (Comparable)facing), 3);
        return facing;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        this.setDefaultDirection(worldIn, pos, state);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        this.setOrientWhenPlacing(worldIn, pos, state, placer);
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return EnumFacing.UP == side;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }
}

