/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.common.tileentity.device;

import growthcraft.cellar.common.tileentity.TileEntityCellarDevice;
import growthcraft.cellar.common.tileentity.TileEntityFruitPress;
import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.cellar.shared.processing.pressing.IPressingRecipe;
import growthcraft.core.shared.item.ItemUtils;
import growthcraft.core.shared.tileentity.device.DeviceFluidSlot;
import growthcraft.core.shared.tileentity.device.DeviceInventorySlot;
import growthcraft.core.shared.tileentity.device.DeviceProgressive;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class FruitPress
extends DeviceProgressive<IPressingRecipe> {
    private float pomace;
    private DeviceFluidSlot fluidSlot;
    private DeviceInventorySlot inputSlot;
    private DeviceInventorySlot residueSlot;

    public FruitPress(TileEntityCellarDevice te, int fs, int is, int rs) {
        super(te);
        this.fluidSlot = new DeviceFluidSlot(te, fs);
        this.inputSlot = new DeviceInventorySlot((IInventory)te, is);
        this.residueSlot = new DeviceInventorySlot((IInventory)te, rs);
    }

    public boolean isPressed() {
        if (this.parent instanceof TileEntityFruitPress) {
            return ((TileEntityFruitPress)this.parent).isPressed();
        }
        return false;
    }

    @Override
    protected IPressingRecipe loadRecipe() {
        return CellarRegistry.instance().pressing().getPressingRecipe(this.inputSlot.get());
    }

    @Override
    protected float getSpeedMultiplier() {
        return super.getSpeedMultiplier() * (float)(this.isPressed() ? 1 : 0);
    }

    @Override
    protected boolean canProcess() {
        IPressingRecipe recipe = (IPressingRecipe)this.getWorkingRecipe();
        if (recipe == null) {
            return false;
        }
        if (!recipe.getInput().containsItemStack(this.inputSlot.get())) {
            return false;
        }
        if (!this.fluidSlot.hasCapacityFor(recipe.getFluidStack())) {
            return false;
        }
        return this.residueSlot.hasCapacityFor(recipe.getResidue().residueItem);
    }

    public void producePomace() {
        IPressingRecipe recipe = (IPressingRecipe)this.getWorkingRecipe();
        if (recipe == null) {
            return;
        }
        Residue residue = recipe.getResidue();
        if (residue != null) {
            this.pomace += residue.pomaceRate;
            if (this.pomace >= 1.0f) {
                this.pomace -= 1.0f;
                ItemStack residueResult = ItemUtils.mergeStacks(this.residueSlot.get(), residue.residueItem);
                if (!ItemUtils.isEmpty(residueResult)) {
                    this.residueSlot.set(residueResult);
                }
            }
        }
    }

    @Override
    public void process(IPressingRecipe recipe) {
        this.producePomace();
        FluidStack fluidstack = recipe.getFluidStack();
        this.fluidSlot.fill(fluidstack, true);
        this.inputSlot.consume(recipe.getInput());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.pomace = data.func_74760_g("pomace");
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74776_a("pomace", this.pomace);
    }
}

