/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.item;

import growthcraft.cellar.shared.CellarRegistry;
import growthcraft.cellar.shared.booze.BoozeEntry;
import growthcraft.cellar.shared.booze.BoozeUtils;
import growthcraft.cellar.shared.definition.BoozeDefinition;
import growthcraft.cellar.shared.fluids.Booze;
import growthcraft.core.shared.client.GrowthcraftCoreState;
import growthcraft.core.shared.definition.FluidDefinition;
import growthcraft.core.shared.definition.FluidTypeDefinition;
import growthcraft.core.shared.item.IFluidContainerItem;
import growthcraft.core.shared.item.ItemFoodBottleFluid;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBoozeBottle
extends ItemFoodBottleFluid
implements IFluidContainerItem {
    private Booze[] boozes;

    public ItemBoozeBottle() {
        super(null, 0, 0.0f, false);
        this.func_77848_i();
        this.func_77625_d(4);
        this.func_77627_a(true);
        this.func_77656_e(0);
    }

    public ItemBoozeBottle setBoozes(BoozeDefinition[] boozeAry) {
        this.boozes = (Booze[])FluidDefinition.convertArray((FluidTypeDefinition[])boozeAry, Booze.class);
        return this;
    }

    public Booze[] getFluidArray() {
        return this.boozes;
    }

    public Booze getFluidByIndex(int i) {
        if (this.boozes == null) {
            return null;
        }
        return i < 0 || i >= this.boozes.length ? this.boozes[0] : this.boozes[i];
    }

    public Booze getFluid(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        return this.getFluidByIndex(stack.func_77952_i());
    }

    @Override
    public FluidStack getFluidStack(ItemStack stack) {
        Booze fluid = this.getFluid(stack);
        if (fluid == null) {
            return null;
        }
        return new FluidStack((Fluid)fluid, 250);
    }

    public BoozeEntry getBoozeEntry(ItemStack stack) {
        Booze fluid = this.getFluid(stack);
        if (fluid != null) {
            return CellarRegistry.instance().booze().getBoozeEntry(fluid);
        }
        return null;
    }

    public int func_150905_g(ItemStack stack) {
        BoozeEntry entry = this.getBoozeEntry(stack);
        if (entry != null) {
            return entry.getHealAmount();
        }
        return 0;
    }

    public float func_150906_h(ItemStack stack) {
        BoozeEntry entry = this.getBoozeEntry(stack);
        if (entry != null) {
            return entry.getSaturation();
        }
        return 0.0f;
    }

    @Override
    public int getColor(ItemStack stack) {
        Booze booze = this.getFluid(stack);
        if (booze != null) {
            return booze.getColor();
        }
        return 0xFFFFFF;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int par4, boolean par5) {
        if (stack.func_77952_i() >= this.getFluidArray().length) {
            stack.func_77964_b(0);
        }
    }

    @Override
    protected void applyIEffects(ItemStack itemStack, World world, EntityPlayer player) {
        super.applyIEffects(itemStack, world, player);
        BoozeUtils.addEffects(this.getFluid(itemStack), itemStack, world, player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        boolean showDetailed = GrowthcraftCoreState.showDetailedInformation();
        BoozeUtils.addBottleInformation(this.getFluid(stack), stack, worldIn, tooltip, flagIn, showDetailed);
        if (!showDetailed) {
            tooltip.add(TextFormatting.GRAY + I18n.func_74837_a((String)"grc.tooltip.detailed_information", (Object[])new Object[]{TextFormatting.WHITE + "SHIFT" + TextFormatting.GRAY}));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return BoozeUtils.hasEffect(this.getFluid(stack));
    }

    public String func_77667_c(ItemStack stack) {
        Booze booze = this.getFluid(stack);
        return super.func_77658_a() + "_" + booze.getName().substring(12);
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    @Override
    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public String func_77653_i(ItemStack stack) {
        Booze booze = this.getFluid(stack);
        if (booze != null) {
            return I18n.func_74838_a((String)booze.getUnlocalizedName());
        }
        return super.func_77653_i(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < this.getFluidArray().length; ++i) {
            list.add((Object)new ItemStack((Item)this, 1, i));
        }
    }
}

