/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.brewing;

import growthcraft.cellar.shared.processing.brewing.BrewingFallbackRecipe;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.item.ItemTest;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BrewingRecipe
extends BrewingFallbackRecipe {
    private IMultiItemStacks inputItemStack;
    private boolean requiresLid;

    public BrewingRecipe(@Nonnull FluidStack pInputFluid, @Nonnull IMultiItemStacks pInputItem, @Nonnull FluidStack pOutputFluid, boolean requiresLid, int pTime, @Nullable Residue pResidue) {
        super(pInputFluid, pOutputFluid, pTime, pResidue);
        this.inputItemStack = pInputItem;
        this.requiresLid = requiresLid;
    }

    @Override
    public IMultiItemStacks getInputItemStack() {
        return this.inputItemStack;
    }

    @Override
    public boolean matchesRecipe(@Nullable FluidStack fluidStack, @Nullable ItemStack itemStack, boolean requiresLid) {
        if (fluidStack != null && itemStack != null) {
            if (this.requiresLid != requiresLid) {
                return false;
            }
            if (!FluidTest.hasEnough(this.getInputFluidStack(), fluidStack)) {
                return false;
            }
            return ItemTest.hasEnough(this.inputItemStack, itemStack);
        }
        return false;
    }

    @Override
    public boolean matchesIngredient(@Nullable FluidStack fluidStack) {
        return FluidTest.fluidMatches(this.getInputFluidStack(), fluidStack);
    }

    @Override
    public boolean matchesIngredient(@Nullable ItemStack stack) {
        return ItemTest.itemMatches(this.inputItemStack, stack);
    }

    @Override
    public boolean isItemIngredient(@Nullable ItemStack stack) {
        return stack != null && this.inputItemStack.containsItemStack(stack);
    }
}

