/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.brewing;

import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.processing.brewing.BrewingFallbackRecipe;
import growthcraft.cellar.shared.processing.brewing.BrewingRecipe;
import growthcraft.cellar.shared.processing.brewing.IBrewingRecipe;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.item.MultiStacksUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class BrewingRegistry {
    private List<IBrewingRecipe> recipes = new ArrayList<IBrewingRecipe>();

    public void addRecipe(@Nonnull IBrewingRecipe recipe) {
        this.recipes.add(recipe);
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Added Brewing Recipe recipe={%s}", (Object)recipe);
    }

    public void addRecipe(@Nonnull FluidStack sourceFluid, @Nonnull Object raw, @Nonnull FluidStack resultFluid, boolean requiresLid, int time, @Nullable Residue residue) {
        this.addRecipe(new BrewingRecipe(sourceFluid, MultiStacksUtil.toMultiItemStacks(raw), resultFluid, requiresLid, time, residue));
    }

    public void addFallbackRecipe(@Nonnull FluidStack sourceFluid, @Nonnull FluidStack resultFluid, int time, @Nullable Residue residue) {
        this.addRecipe(new BrewingFallbackRecipe(sourceFluid, resultFluid, time, residue));
    }

    public IBrewingRecipe findRecipe(@Nullable FluidStack fluidstack, @Nullable ItemStack itemstack, boolean requiresLid) {
        return this.findRecipe(fluidstack, itemstack, requiresLid, false);
    }

    public IBrewingRecipe findRecipe(@Nullable FluidStack fluidstack, @Nullable ItemStack itemstack, boolean requiresLid, boolean forceAllowFallback) {
        if (itemstack == null || fluidstack == null) {
            return null;
        }
        for (IBrewingRecipe recipe : this.recipes) {
            if (this.isFallbackRecipe(recipe) || !recipe.matchesRecipe(fluidstack, itemstack, requiresLid)) continue;
            return recipe;
        }
        if (GrowthcraftCellarConfig.allowFallbackRecipes || forceAllowFallback) {
            for (IBrewingRecipe recipe : this.recipes) {
                if (!this.isFallbackRecipe(recipe) || !recipe.matchesIngredient(fluidstack)) continue;
                return recipe;
            }
        }
        return null;
    }

    public List<IBrewingRecipe> findRecipes(@Nullable FluidStack fluid) {
        ArrayList<IBrewingRecipe> result = new ArrayList<IBrewingRecipe>();
        if (fluid != null) {
            for (IBrewingRecipe recipe : this.recipes) {
                if (!recipe.matchesIngredient(fluid)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    public List<IBrewingRecipe> findRecipes(@Nullable ItemStack fermenter) {
        return this.findRecipes(fermenter, false);
    }

    public List<IBrewingRecipe> findRecipes(@Nullable ItemStack fermenter, boolean forceAllowFallback) {
        boolean allowFallback = GrowthcraftCellarConfig.allowFallbackRecipes || forceAllowFallback;
        ArrayList<IBrewingRecipe> result = new ArrayList<IBrewingRecipe>();
        if (fermenter != null) {
            for (IBrewingRecipe recipe : this.recipes) {
                if (allowFallback && this.isFallbackRecipe(recipe)) {
                    result.add(recipe);
                    continue;
                }
                if (!recipe.matchesIngredient(fermenter)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    public boolean isBrewingRecipe(@Nullable FluidStack fluidstack, @Nullable ItemStack itemstack, boolean requiresLid) {
        return this.findRecipe(fluidstack, itemstack, requiresLid) != null;
    }

    public boolean isItemBrewingIngredient(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        for (IBrewingRecipe recipe : this.recipes) {
            if (this.isFallbackRecipe(recipe) || !recipe.isItemIngredient(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isFallbackRecipe(IBrewingRecipe recipe) {
        return recipe instanceof BrewingFallbackRecipe && !(recipe instanceof BrewingRecipe);
    }
}

