/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.culturing;

import growthcraft.cellar.shared.processing.culturing.CultureRecipe;
import growthcraft.cellar.shared.processing.culturing.ICultureRecipe;
import growthcraft.core.shared.GrowthcraftLogger;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CulturingRegistry {
    private List<ICultureRecipe> recipes = new ArrayList<ICultureRecipe>();

    public void addRecipe(@Nonnull ICultureRecipe recipe) {
        this.recipes.add(recipe);
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Adding new Culturing Recipe, {%s}.", (Object)recipe);
    }

    public void addRecipe(@Nonnull FluidStack fluidStack, @Nonnull ItemStack itemStack, float requiredHeat, int time) {
        this.addRecipe(new CultureRecipe(fluidStack, itemStack, requiredHeat, time));
    }

    public ICultureRecipe findRecipe(@Nullable FluidStack fluid, float heat) {
        for (ICultureRecipe recipe : this.recipes) {
            if (!recipe.matchesRecipe(fluid, heat)) continue;
            return recipe;
        }
        return null;
    }
}

