/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.cellar.shared.processing.fermenting;

import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.processing.fermenting.FermentationFallbackRecipe;
import growthcraft.cellar.shared.processing.fermenting.FermentationRecipe;
import growthcraft.cellar.shared.processing.fermenting.IFermentationRecipe;
import growthcraft.core.shared.GrowthcraftLogger;
import growthcraft.core.shared.item.MultiStacksUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class FermentingRegistry {
    private List<IFermentationRecipe> recipes = new ArrayList<IFermentationRecipe>();

    private void onRecipeAdded(@Nonnull IFermentationRecipe recipe) {
        GrowthcraftLogger.getLogger("growthcraft_cellar").debug("Added Fermentation recipe={%s}", (Object)recipe);
    }

    public void addRecipe(@Nonnull IFermentationRecipe recipe) {
        this.recipes.add(recipe);
        this.onRecipeAdded(recipe);
    }

    public void addRecipe(@Nonnull FluidStack result, @Nonnull Object booze, @Nonnull Object fermenter, int time) {
        this.addRecipe(new FermentationRecipe(MultiStacksUtil.toMultiFluidStacks(booze), MultiStacksUtil.toMultiItemStacks(fermenter), result, time));
    }

    public void addFallbackRecipe(@Nonnull FluidStack result, @Nonnull Object booze, int time) {
        this.addRecipe(new FermentationFallbackRecipe(MultiStacksUtil.toMultiFluidStacks(booze), result, time));
    }

    public IFermentationRecipe findRecipe(@Nullable FluidStack booze, @Nullable ItemStack fermenter) {
        return this.findRecipe(booze, fermenter, false);
    }

    public IFermentationRecipe findRecipe(@Nullable FluidStack booze, @Nullable ItemStack fermenter, boolean forceAllowFallback) {
        if (booze == null || fermenter == null) {
            return null;
        }
        for (IFermentationRecipe recipe : this.recipes) {
            if (this.isFallbackRecipe(recipe) || !recipe.matchesRecipe(booze, fermenter)) continue;
            return recipe;
        }
        if (GrowthcraftCellarConfig.allowFallbackRecipes || forceAllowFallback) {
            for (IFermentationRecipe recipe : this.recipes) {
                if (!this.isFallbackRecipe(recipe) || !recipe.matchesIngredient(booze)) continue;
                return recipe;
            }
        }
        return null;
    }

    public List<IFermentationRecipe> findRecipes(@Nullable FluidStack fluid) {
        ArrayList<IFermentationRecipe> result = new ArrayList<IFermentationRecipe>();
        if (fluid != null) {
            for (IFermentationRecipe recipe : this.recipes) {
                if (!recipe.matchesIngredient(fluid)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    public List<IFermentationRecipe> findRecipes(@Nullable ItemStack fermenter) {
        return this.findRecipes(fermenter, false);
    }

    public List<IFermentationRecipe> findRecipes(@Nullable ItemStack fermenter, boolean forceAllowFallback) {
        boolean allowFallback = GrowthcraftCellarConfig.allowFallbackRecipes || forceAllowFallback;
        ArrayList<IFermentationRecipe> result = new ArrayList<IFermentationRecipe>();
        if (fermenter != null) {
            for (IFermentationRecipe recipe : this.recipes) {
                if (allowFallback && this.isFallbackRecipe(recipe)) {
                    result.add(recipe);
                    continue;
                }
                if (!recipe.matchesIngredient(fermenter)) continue;
                result.add(recipe);
            }
        }
        return result;
    }

    public boolean canFerment(@Nullable FluidStack fluid) {
        if (fluid != null) {
            for (IFermentationRecipe recipe : this.recipes) {
                if (!recipe.matchesIngredient(fluid)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isItemFermentationIngredient(@Nullable ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        for (IFermentationRecipe recipe : this.recipes) {
            if (this.isFallbackRecipe(recipe) || !recipe.isItemIngredient(itemstack)) continue;
            return true;
        }
        return false;
    }

    public boolean isFallbackRecipe(IFermentationRecipe recipe) {
        return recipe instanceof FermentationFallbackRecipe && !(recipe instanceof FermentationRecipe);
    }
}

