/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.block;

import growthcraft.core.common.block.BlockRopeBase;
import growthcraft.core.shared.block.IBlockRope;
import growthcraft.core.shared.init.GrowthcraftCoreItems;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRopeFence
extends BlockRopeBase {
    private static final AxisAlignedBB KNOT_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.4375, 0.4375, 0.5625, 0.5625, 0.5625);
    private static final AxisAlignedBB NORTH_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 0.4375);
    private static final AxisAlignedBB EAST_BOUNDING_BOX = new AxisAlignedBB(0.5625, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
    private static final AxisAlignedBB SOUTH_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.4375, 0.5625, 0.5625, 0.5625, 1.0);
    private static final AxisAlignedBB WEST_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.4375, 0.4375, 0.4375, 0.5625, 0.5625);
    private static final AxisAlignedBB UP_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.5625, 0.4375, 0.5625, 1.0, 0.5625);
    private static final AxisAlignedBB DOWN_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 0.4375, 0.5625);
    public static final PropertyBool NORTH = PropertyBool.func_177716_a((String)"north");
    public static final PropertyBool EAST = PropertyBool.func_177716_a((String)"east");
    public static final PropertyBool SOUTH = PropertyBool.func_177716_a((String)"south");
    public static final PropertyBool WEST = PropertyBool.func_177716_a((String)"west");
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");

    public BlockRopeFence(String unlocalizedName) {
        super(Material.field_151593_r);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft", unlocalizedName));
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void populateCollisionBoxes(IBlockState actualState, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes) {
        BlockRopeFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)KNOT_BOUNDING_BOX);
        if (((Boolean)actualState.func_177229_b((IProperty)NORTH)).booleanValue()) {
            BlockRopeFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)NORTH_BOUNDING_BOX);
        }
        if (((Boolean)actualState.func_177229_b((IProperty)EAST)).booleanValue()) {
            BlockRopeFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)EAST_BOUNDING_BOX);
        }
        if (((Boolean)actualState.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            BlockRopeFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SOUTH_BOUNDING_BOX);
        }
        if (((Boolean)actualState.func_177229_b((IProperty)WEST)).booleanValue()) {
            BlockRopeFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)WEST_BOUNDING_BOX);
        }
        if (((Boolean)actualState.func_177229_b((IProperty)UP)).booleanValue()) {
            BlockRopeFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)UP_BOUNDING_BOX);
        }
        if (((Boolean)actualState.func_177229_b((IProperty)DOWN)).booleanValue()) {
            BlockRopeFence.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)DOWN_BOUNDING_BOX);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            ItemStack rope = GrowthcraftCoreItems.rope.asStack(1);
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)rope);
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_176198_a(World worldIn, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(worldIn, pos, side);
    }

    @Override
    public boolean canConnectRopeTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block instanceof IBlockRope;
    }

    @Override
    public boolean canRopeBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return BlockRopeFence.class.isInstance(block);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        boolean vN = this.canConnectRopeTo(worldIn, pos, EnumFacing.NORTH);
        boolean vE = this.canConnectRopeTo(worldIn, pos, EnumFacing.EAST);
        boolean vS = this.canConnectRopeTo(worldIn, pos, EnumFacing.SOUTH);
        boolean vW = this.canConnectRopeTo(worldIn, pos, EnumFacing.WEST);
        boolean vU = this.canConnectRopeTo(worldIn, pos, EnumFacing.UP);
        boolean vD = this.canConnectRopeTo(worldIn, pos, EnumFacing.DOWN);
        if (!(vN || vE || vS || vW || vU || vD)) {
            vN = true;
            vE = true;
            vS = true;
            vW = true;
            vU = true;
            vD = true;
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(vN)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(vE)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(vS)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(vW)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(vU)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(vD));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }
}

