/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.common.block;

import growthcraft.core.common.block.BlockRopeBase;
import growthcraft.core.common.block.BlockRopeFence;
import growthcraft.core.shared.block.FenceUtils;
import growthcraft.core.shared.block.IBlockRope;
import growthcraft.core.shared.init.GrowthcraftCoreItems;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRopeKnot
extends BlockRopeBase {
    private static final AxisAlignedBB FENCE_BOUNDING_BOX = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB FENCE_COLLISION_EXTRA_BOX = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 1.5, 0.6875);
    private static final AxisAlignedBB KNOT_BOUNDING_BOX = new AxisAlignedBB(0.3125, 0.375, 0.3125, 0.6875, 0.875, 0.6875);
    private static final AxisAlignedBB NORTH_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 0.3125);
    private static final AxisAlignedBB EAST_BOUNDING_BOX = new AxisAlignedBB(0.6875, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
    private static final AxisAlignedBB SOUTH_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.4375, 0.6875, 0.5625, 0.5625, 1.0);
    private static final AxisAlignedBB WEST_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.4375, 0.4375, 0.3125, 0.5625, 0.5625);
    private static final AxisAlignedBB FENCE_NORTH_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.375, 0.0, 0.5625, 0.9375, 0.3125);
    private static final AxisAlignedBB FENCE_EAST_BOUNDING_BOX = new AxisAlignedBB(0.6875, 0.375, 0.4375, 1.0, 0.9375, 0.5625);
    private static final AxisAlignedBB FENCE_SOUTH_BOUNDING_BOX = new AxisAlignedBB(0.4375, 0.375, 0.6875, 0.5625, 0.9375, 1.0);
    private static final AxisAlignedBB FENCE_WEST_BOUNDING_BOX = new AxisAlignedBB(0.0, 0.375, 0.4375, 0.3125, 0.9375, 0.5625);
    public static final PropertyInteger NORTH = PropertyInteger.func_177719_a((String)"north", (int)0, (int)2);
    public static final PropertyInteger EAST = PropertyInteger.func_177719_a((String)"east", (int)0, (int)2);
    public static final PropertyInteger SOUTH = PropertyInteger.func_177719_a((String)"south", (int)0, (int)2);
    public static final PropertyInteger WEST = PropertyInteger.func_177719_a((String)"west", (int)0, (int)2);
    public static final PropertyBool UP = PropertyBool.func_177716_a((String)"up");
    public static final PropertyBool DOWN = PropertyBool.func_177716_a((String)"down");
    private Block baseFence;
    private boolean sneakBreak = false;

    public BlockRopeKnot(String unlocalizedName) {
        this(unlocalizedName, Blocks.field_180407_aO);
    }

    public BlockRopeKnot(String unlocalizedName, Block baseFence) {
        this(unlocalizedName, baseFence, "growthcraft");
    }

    public BlockRopeKnot(String unlocalizedName, Block baseFence, String modid) {
        super(Material.field_151575_d);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation(modid, unlocalizedName));
        this.func_149711_c(3.0f);
        this.func_149752_b(20.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)EAST, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)SOUTH, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)WEST, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
        this.field_149783_u = true;
        this.baseFence = baseFence;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public Block getFenceBlock() {
        return this.baseFence;
    }

    @Override
    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockRopeKnot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FENCE_COLLISION_EXTRA_BOX);
        super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
    }

    @Override
    protected void populateCollisionBoxes(IBlockState actualState, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes) {
        BlockRopeKnot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)FENCE_BOUNDING_BOX);
        BlockRopeKnot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)KNOT_BOUNDING_BOX);
        int vN = (Integer)actualState.func_177229_b((IProperty)NORTH);
        int vE = (Integer)actualState.func_177229_b((IProperty)EAST);
        int vS = (Integer)actualState.func_177229_b((IProperty)SOUTH);
        int vW = (Integer)actualState.func_177229_b((IProperty)WEST);
        if (vN != 0) {
            BlockRopeKnot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)(vN == 1 ? NORTH_BOUNDING_BOX : FENCE_NORTH_BOUNDING_BOX));
        }
        if (vE != 0) {
            BlockRopeKnot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)(vE == 1 ? EAST_BOUNDING_BOX : FENCE_EAST_BOUNDING_BOX));
        }
        if (vS != 0) {
            BlockRopeKnot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)(vS == 1 ? SOUTH_BOUNDING_BOX : FENCE_SOUTH_BOUNDING_BOX));
        }
        if (vW != 0) {
            BlockRopeKnot.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)(vW == 1 ? WEST_BOUNDING_BOX : FENCE_WEST_BOUNDING_BOX));
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (playerIn.func_70093_af()) {
            worldIn.func_175656_a(pos, this.baseFence.func_176223_P());
            this.sneakBreak = true;
        }
        return false;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        ItemStack rope = GrowthcraftCoreItems.rope.asStack(1);
        InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)rope);
        if (!this.sneakBreak) {
            InventoryHelper.func_180173_a((World)worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)new ItemStack(this.baseFence));
        }
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    @Override
    public boolean canConnectRopeTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block instanceof IBlockRope;
    }

    @Override
    public boolean canRopeBeConnectedTo(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.func_180495_p(pos.func_177972_a(facing)).func_177230_c();
        return block instanceof BlockRopeFence || block instanceof BlockRopeKnot;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        int vN = this.getConnectionValue(worldIn, pos, EnumFacing.NORTH);
        int vE = this.getConnectionValue(worldIn, pos, EnumFacing.EAST);
        int vS = this.getConnectionValue(worldIn, pos, EnumFacing.SOUTH);
        int vW = this.getConnectionValue(worldIn, pos, EnumFacing.WEST);
        return state.func_177226_a((IProperty)NORTH, (Comparable)Integer.valueOf(vN)).func_177226_a((IProperty)EAST, (Comparable)Integer.valueOf(vE)).func_177226_a((IProperty)SOUTH, (Comparable)Integer.valueOf(vS)).func_177226_a((IProperty)WEST, (Comparable)Integer.valueOf(vW)).func_177226_a((IProperty)UP, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.UP))).func_177226_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.canConnectRopeTo(worldIn, pos, EnumFacing.DOWN)));
    }

    private int getConnectionValue(IBlockAccess worldIn, BlockPos pos, EnumFacing facing) {
        if (this.canConnectRopeTo(worldIn, pos, facing)) {
            return 1;
        }
        if (FenceUtils.canFenceConnectTo(worldIn, pos, facing)) {
            return 2;
        }
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE : BlockFaceShape.CENTER;
    }

    public boolean func_176205_b(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }
}

