/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.config.schema;

import growthcraft.core.shared.config.schema.ICommentable;
import growthcraft.core.shared.config.schema.IValidatable;
import growthcraft.core.shared.definition.IItemStackFactory;
import growthcraft.core.shared.definition.IItemStackListProvider;
import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.item.MultiItemStacks;
import growthcraft.core.shared.utils.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ItemStackSchema
implements IItemStackFactory,
IItemStackListProvider,
IValidatable,
ICommentable {
    public String comment;
    public String mod_id;
    public String name;
    public int amount;
    public int meta;

    public ItemStackSchema(@Nonnull String mid, @Nonnull String nm, int amt, int mt) {
        this.mod_id = mid;
        this.name = nm;
        this.amount = amt;
        this.meta = mt;
        this.comment = "";
    }

    public ItemStackSchema(@Nonnull ItemStack stack) {
        ResourceLocation resloc = stack.func_77973_b().getRegistryName();
        this.mod_id = resloc.func_110624_b();
        this.name = resloc.func_110623_a();
        this.amount = stack.func_190916_E();
        this.meta = stack.func_77952_i();
        this.comment = stack.func_82833_r();
    }

    public ItemStackSchema() {
        this.amount = 1;
        this.meta = Short.MAX_VALUE;
        this.comment = "";
    }

    @Override
    public void setComment(String comm) {
        this.comment = comm;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public Item getItem() {
        if (this.mod_id == null || this.name == null) {
            return null;
        }
        return Item.func_111206_d((String)(this.mod_id + ":" + this.name));
    }

    @Override
    public ItemStack asStack(int a) {
        Item item = this.getItem();
        if (item == null) {
            return null;
        }
        return new ItemStack(item, a, this.meta < 0 ? Short.MAX_VALUE : this.meta);
    }

    @Override
    public ItemStack asStack() {
        return this.asStack(this.amount);
    }

    @Override
    public List<ItemStack> getItemStacks() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        ItemStack stack = this.asStack();
        if (stack != null) {
            result.add(stack);
        }
        return result;
    }

    public List<IMultiItemStacks> getMultiItemStacks() {
        ArrayList<IMultiItemStacks> result = new ArrayList<IMultiItemStacks>();
        ItemStack stack = this.asStack();
        if (stack != null) {
            result.add(new MultiItemStacks(stack));
        }
        return result;
    }

    public String toString() {
        return String.format("Schema<ItemStack>(comment: '%s', mod_id: '%s', name: '%s', meta: %d, amount: %d)", StringUtils.inspect(this.comment), this.mod_id, this.name, this.meta, this.amount);
    }

    @Override
    public boolean isValid() {
        return this.asStack() != null;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }
}

