/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.definition;

import growthcraft.core.shared.definition.IObjectVariant;
import growthcraft.core.shared.definition.ISubItemStackFactory;
import growthcraft.core.shared.definition.ObjectDefinition;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class ItemTypeDefinition<T extends Item>
extends ObjectDefinition<T>
implements ISubItemStackFactory {
    public ItemTypeDefinition(@Nonnull T item) {
        super(item);
    }

    @Nonnull
    public T getItem() {
        return (T)((Item)this.getObject());
    }

    @Override
    @Nonnull
    public ItemStack asStack(int size, int damage) {
        return new ItemStack(this.getItem(), size, damage);
    }

    public boolean equals(Item other) {
        if (other == null) {
            return false;
        }
        return this.getItem() == other;
    }

    public void registerItem(IForgeRegistry<Item> registry, ResourceLocation name) {
        this.getItem().func_77655_b(name.func_110623_a());
        this.getItem().setRegistryName(name);
        this.registerItem(registry);
    }

    public void registerItem(IForgeRegistry<Item> registry) {
        registry.register(this.getItem());
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRender() {
        ModelLoader.setCustomModelResourceLocation(this.getItem(), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getItem().getRegistryName(), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRender(int meta, String fileName) {
        String modID = this.getItem().getRegistryName().func_110624_b();
        ModelLoader.setCustomModelResourceLocation(this.getItem(), (int)meta, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation(modID, fileName), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public <ET extends Enum<?> & IStringSerializable> void registerRenders(Class<ET> clazz) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        this.registerRenders((IObjectVariant[])values);
    }

    @SideOnly(value=Side.CLIENT)
    public <ET extends IObjectVariant & IStringSerializable> void registerRenders(ET ... variants) {
        ResourceLocation itemResloc = this.getItem().getRegistryName();
        for (ET type : variants) {
            this.registerRender(type.getVariantID(), itemResloc.func_110623_a() + "_" + ((IStringSerializable)type).func_176610_l());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public <ET extends Enum<?>> void registerModelBakeryVariants(Class<ET> clazz) {
        Enum[] values = (Enum[])clazz.getEnumConstants();
        this.registerModelBakeryVariants((IStringSerializable[])values);
    }

    @SideOnly(value=Side.CLIENT)
    public <ET extends IStringSerializable> void registerModelBakeryVariants(ET ... variants) {
        ResourceLocation itemResloc = this.getItem().getRegistryName();
        ResourceLocation[] reslocs = new ResourceLocation[variants.length];
        for (int i = 0; i < reslocs.length; ++i) {
            ET type = variants[i];
            reslocs[i] = new ResourceLocation(itemResloc.func_110624_b(), itemResloc.func_110623_a() + "_" + type.func_176610_l());
        }
        ModelBakery.registerItemVariants(this.getItem(), (ResourceLocation[])reslocs);
    }
}

