/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.effect;

import growthcraft.core.shared.CoreRegistry;
import growthcraft.core.shared.effect.IEffect;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public abstract class AbstractEffect
implements IEffect {
    protected boolean descriptionEnabled = true;

    public <T extends AbstractEffect> T toggleDescription(boolean bool) {
        this.descriptionEnabled = bool;
        return (T)this;
    }

    protected abstract void readFromNBT(NBTTagCompound var1);

    @Override
    public void readFromNBT(NBTTagCompound data, String name) {
        if (data.func_74764_b(name)) {
            NBTTagCompound effectData = data.func_74775_l(name);
            this.readFromNBT(effectData);
        }
    }

    protected abstract void writeToNBT(NBTTagCompound var1);

    @Override
    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound target = new NBTTagCompound();
        String effectName = CoreRegistry.instance().getEffectsRegistry().getName(this.getClass());
        target.func_74778_a("__name__", effectName);
        this.writeToNBT(target);
        data.func_74782_a(name, (NBTBase)target);
    }

    protected abstract void getActualDescription(List<String> var1);

    @Override
    public void getDescription(List<String> list) {
        if (this.descriptionEnabled) {
            this.getActualDescription(list);
        }
    }
}

