/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.effect;

import growthcraft.core.shared.effect.AbstractEffect;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class EffectRemovePotionEffect
extends AbstractEffect {
    private Potion potion;

    public EffectRemovePotionEffect(Potion potion) {
        this.potion = potion;
    }

    public EffectRemovePotionEffect() {
    }

    public EffectRemovePotionEffect setPotion(Potion potion) {
        this.potion = potion;
        return this;
    }

    public Potion getPotion() {
        return this.potion;
    }

    @Override
    public void apply(World world, Entity entity, Random random, Object data) {
        if (this.potion != null && entity instanceof EntityLivingBase) {
            ((EntityLivingBase)entity).func_184589_d(this.potion);
        }
    }

    @Override
    protected void getActualDescription(List<String> list) {
        PotionEffect pe = new PotionEffect(this.getPotion(), 1000, 0);
        String potionName = I18n.func_74838_a((String)pe.func_76453_d()).trim();
        list.add(I18n.func_74837_a((String)"effect.remove_potion_effect.format", (Object[])new Object[]{potionName}));
    }

    @Override
    protected void readFromNBT(NBTTagCompound data) {
        this.potion = Potion.func_188412_a((int)data.func_74762_e("potion_id"));
    }

    @Override
    protected void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("potion_id", Potion.func_188409_a((Potion)this.potion));
    }
}

