/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.fluids;

import growthcraft.core.shared.block.GrowthcraftBlockFluid;
import growthcraft.core.shared.client.render.utils.ItemRenderUtils;
import growthcraft.core.shared.definition.FluidDefinition;
import growthcraft.core.shared.definition.GrowthcraftBlockFluidDefinition;
import growthcraft.core.shared.definition.ItemTypeDefinition;
import growthcraft.core.shared.item.ItemBottleFluid;
import growthcraft.core.shared.item.ItemFoodBottleFluid;
import growthcraft.core.shared.legacy.FluidContainerRegistry;
import growthcraft.core.shared.utils.NumUtils;
import growthcraft.core.shared.utils.ObjectUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class FluidFactory {
    public static final int FEATURE_BLOCK = 1;
    public static final int FEATURE_BOTTLE = 2;
    public static final int FEATURE_FOOD_BOTTLE = 4;
    public static final int FEATURE_BUCKET = 8;
    public static final int FEATURE_NONE = 0;
    public static final int FEATURE_ALL_NON_EDIBLE = 11;
    public static final int FEATURE_ALL_EDIBLE = 13;
    private static FluidFactory INSTANCE = new FluidFactory();

    public static FluidFactory instance() {
        return INSTANCE;
    }

    public static class FluidDetailsBuilder {
        private final FluidDetails prototype = new FluidDetails();
        private final Fluid fluid;
        private final int defaultFeatures;
        private Class<? extends GrowthcraftBlockFluid> fluidBlockClazz = null;

        public FluidDetailsBuilder(Fluid fluid) {
            this(fluid, 11);
        }

        public FluidDetailsBuilder(Fluid fluid, int defaultFeatures) {
            this.fluid = fluid;
            this.defaultFeatures = defaultFeatures;
        }

        public FluidDetailsBuilder setFluidBlock(GrowthcraftBlockFluid block) {
            this.prototype.block = new GrowthcraftBlockFluidDefinition(block);
            return this;
        }

        public FluidDetailsBuilder setFluidBlockClass(Class<? extends GrowthcraftBlockFluid> fluidBlockClazz) {
            this.fluidBlockClazz = fluidBlockClazz;
            return this;
        }

        public FluidDetailsBuilder setBottle(ItemBottleFluid bottle) {
            this.prototype.bottle = new ItemTypeDefinition<ItemBottleFluid>(bottle);
            return this;
        }

        public FluidDetailsBuilder setFoodBottle(ItemFoodBottleFluid foodBottle) {
            this.prototype.foodBottle = new ItemTypeDefinition<ItemFoodBottleFluid>(foodBottle);
            return this;
        }

        public FluidDetails build() {
            FluidDetails details = this.prototype.clone();
            details.fluid = new FluidDefinition(this.fluid);
            if (!FluidRegistry.isFluidRegistered((Fluid)this.fluid)) {
                details.fluid.register();
            }
            if (NumUtils.isFlagged(this.defaultFeatures, 8)) {
                details.hasBucket = true;
            }
            if (details.block == null && this.fluidBlockClazz != null) {
                try {
                    Constructor<? extends GrowthcraftBlockFluid> constr = this.fluidBlockClazz.getConstructor(Fluid.class);
                    details.block = new GrowthcraftBlockFluidDefinition(constr.newInstance(this.fluid));
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    throw new IllegalArgumentException("Failed to construct a fluid block. Details: " + e.getMessage(), e);
                }
            }
            if (details.block == null && NumUtils.isFlagged(this.defaultFeatures, 1)) {
                details.block = GrowthcraftBlockFluidDefinition.create(this.fluid);
            }
            if (details.bottle == null && NumUtils.isFlagged(this.defaultFeatures, 2)) {
                details.bottle = new ItemTypeDefinition<ItemBottleFluid>(new ItemBottleFluid(this.fluid));
            }
            if (details.foodBottle == null && NumUtils.isFlagged(this.defaultFeatures, 4)) {
                details.foodBottle = new ItemTypeDefinition<ItemFoodBottleFluid>(new ItemFoodBottleFluid(this.fluid));
            }
            details.refreshItemColor();
            details.refreshBlockColor();
            return details;
        }
    }

    public static class FluidDetails {
        private FluidDefinition fluid;
        private GrowthcraftBlockFluidDefinition block;
        private ItemTypeDefinition<ItemBottleFluid> bottle;
        private ItemTypeDefinition<ItemFoodBottleFluid> foodBottle;
        private boolean hasBucket = false;
        private ItemStack bucketStack;
        private int itemColor = 0xFFFFFF;

        public Fluid getFluid() {
            return this.fluid.getFluid();
        }

        public FluidDetails clone() {
            FluidDetails copy = new FluidDetails();
            copy.block = this.block;
            copy.bottle = this.bottle;
            copy.bucketStack = this.bucketStack;
            copy.fluid = this.fluid;
            copy.foodBottle = this.foodBottle;
            copy.itemColor = this.itemColor;
            return copy;
        }

        public FluidDefinition getFluidDefinition() {
            return this.fluid;
        }

        public FluidStack asFluidStack(int size) {
            return this.fluid.asFluidStack(size);
        }

        public Block getFluidBlock() {
            return this.block != null ? (Block)this.block.getBlock() : null;
        }

        public ItemStack asFluidBlockItemStack(int size) {
            return this.block != null ? this.block.asStack(size) : null;
        }

        public ItemStack asFluidBlockItemStack() {
            return this.asFluidBlockItemStack(1);
        }

        public ItemStack asBucketItemStack(int size) {
            if (this.bucketStack == null) {
                return null;
            }
            ItemStack stack = this.bucketStack.func_77946_l();
            stack.func_190920_e(size);
            return stack;
        }

        public ItemStack asBucketItemStack() {
            return this.asBucketItemStack(1);
        }

        public ItemStack asFoodBottleItemStack(int size) {
            return this.foodBottle != null ? this.foodBottle.asStack(size) : null;
        }

        public ItemStack asFoodBottleItemStack() {
            return this.asFoodBottleItemStack(1);
        }

        public ItemStack asGenericBottleItemStack(int size) {
            return this.bottle != null ? this.bottle.asStack(size) : null;
        }

        public ItemStack asGenericBottleItemStack() {
            return this.asGenericBottleItemStack(1);
        }

        public ItemStack asBottleItemStack(int size) {
            return ObjectUtils.maybe(this.asFoodBottleItemStack(size), this.asGenericBottleItemStack(size));
        }

        public ItemStack asBottleItemStack() {
            return this.asBottleItemStack(1);
        }

        public GrowthcraftBlockFluidDefinition getFluidBlockDefinition() {
            return this.block;
        }

        public ItemTypeDefinition<ItemBottleFluid> getBottle() {
            return this.bottle;
        }

        public ItemTypeDefinition<ItemFoodBottleFluid> getFoodBottle() {
            return this.foodBottle;
        }

        public FluidDetails registerBlocks(IForgeRegistry<Block> registry, String modID, String basename) {
            if (this.block != null) {
                this.block.register(registry, new ResourceLocation(modID, "fluid_" + basename));
            }
            return this;
        }

        public FluidDetails registerItems(IForgeRegistry<Item> registry, String modID, String basename) {
            FluidStack fluidStack;
            if (this.bottle != null) {
                this.bottle.registerItem(registry, new ResourceLocation(modID, "bottlefluid_" + basename));
                fluidStack = this.fluid.asFluidStack(250);
                FluidContainerRegistry.registerFluidContainer(fluidStack, this.bottle.asStack(1), new ItemStack(Items.field_151069_bo, 1));
            }
            if (this.foodBottle != null) {
                this.foodBottle.registerItem(registry, new ResourceLocation(modID, "bottlefluid_" + basename));
                fluidStack = this.fluid.asFluidStack(250);
                FluidContainerRegistry.registerFluidContainer(fluidStack, this.foodBottle.asStack(1), new ItemStack(Items.field_151069_bo, 1));
            }
            if (this.hasBucket) {
                this.fluid.registerBucketItem();
                if (this.bucketStack == null) {
                    this.bucketStack = UniversalBucket.getFilledBucket((UniversalBucket)ForgeModContainer.getInstance().universalBucket, this.fluid.getFluid());
                }
            }
            return this;
        }

        @SideOnly(value=Side.CLIENT)
        public FluidDetails registerColorHandlers() {
            if (this.bottle != null) {
                ItemRenderUtils.registerItemColorHandler(this.bottle.getItem());
            }
            if (this.foodBottle != null) {
                ItemRenderUtils.registerItemColorHandler((Item)this.foodBottle.getItem());
            }
            return this;
        }

        public FluidDetails registerRenderer() {
            this.fluid.registerRenderer();
            if (this.bottle != null) {
                this.bottle.registerRender();
            }
            if (this.foodBottle != null) {
                this.foodBottle.registerRender();
            }
            return this;
        }

        public FluidDetails setCreativeTab(CreativeTabs tab) {
            if (this.block != null) {
                ((GrowthcraftBlockFluid)((Object)this.block.getBlock())).func_149647_a(tab);
            }
            if (this.bottle != null) {
                this.bottle.getItem().func_77637_a(tab);
            }
            if (this.foodBottle != null) {
                this.foodBottle.getItem().func_77637_a(tab);
            }
            return this;
        }

        public FluidDetails setItemColor(int color) {
            this.itemColor = color;
            if (this.bottle != null) {
                this.bottle.getItem().setColor(color);
            }
            if (this.foodBottle != null) {
                this.foodBottle.getItem().setColor(color);
            }
            return this;
        }

        public FluidDetails setBlockColor(int color) {
            if (this.block != null) {
                ((GrowthcraftBlockFluid)((Object)this.block.getBlock())).setColor(color);
            }
            return this;
        }

        public FluidDetails refreshItemColor() {
            return this.setItemColor(this.fluid.getFluid().getColor());
        }

        public FluidDetails refreshBlockColor() {
            return this.setBlockColor(this.fluid.getFluid().getColor());
        }

        public int getItemColor() {
            return this.itemColor;
        }
    }
}

