/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.inventory;

import growthcraft.core.shared.definition.IMultiItemStacks;
import growthcraft.core.shared.item.ItemTest;
import growthcraft.core.shared.item.ItemUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;

public class InventoryProcessor {
    private static final InventoryProcessor inst = new InventoryProcessor();

    private InventoryProcessor() {
    }

    public List<ItemStack> getInventoryList(@Nonnull IInventory inv) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            result.add(inv.func_70301_a(i));
        }
        return result;
    }

    public void shuffleInventory(@Nonnull IInventory inv, @Nonnull Random random) {
        List<ItemStack> list = this.getInventoryList(inv);
        Collections.shuffle(list, random);
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            inv.func_70299_a(i, list.get(i));
        }
    }

    public boolean slotIsEmpty(@Nonnull IInventory inv, int slot) {
        return ItemUtils.isEmpty(inv.func_70301_a(slot));
    }

    public boolean slotsAreEmpty(@Nonnull IInventory inv, @Nonnull int[] slots) {
        for (int slot : slots) {
            if (ItemUtils.isEmpty(inv.func_70301_a(slot))) continue;
            return false;
        }
        return true;
    }

    public boolean slotsAreEmpty(@Nonnull IInventory inv) {
        for (int slot = 0; slot < inv.func_70302_i_(); ++slot) {
            if (ItemUtils.isEmpty(inv.func_70301_a(slot))) continue;
            return false;
        }
        return true;
    }

    public boolean mergeWithSlot(@Nonnull IInventory inv, @Nullable ItemStack item, int slot) {
        if (!ItemTest.isValid(item)) {
            return false;
        }
        ItemStack existing = inv.func_70301_a(slot);
        if (ItemUtils.isEmpty(existing)) {
            inv.func_70299_a(slot, item.func_77946_l());
            item.func_190920_e(item.func_190916_E() - MathHelper.func_76125_a((int)item.func_190916_E(), (int)0, (int)item.func_77976_d()));
        } else if (existing.func_77969_a(item)) {
            int maxStackSize = inv.func_70297_j_();
            int newSize = MathHelper.func_76125_a((int)(existing.func_190916_E() + item.func_190916_E()), (int)0, (int)maxStackSize);
            if (newSize == existing.func_190916_E()) {
                return false;
            }
            int consumed = newSize - existing.func_190916_E();
            item.func_190920_e(item.func_190916_E() - consumed);
            existing.func_190920_e(newSize);
            inv.func_70299_a(slot, existing);
        } else {
            return false;
        }
        return true;
    }

    public boolean mergeWithSlots(@Nonnull IInventory inv, @Nullable ItemStack stack, int[] slots) {
        if (ItemUtils.isEmpty(stack)) {
            return false;
        }
        boolean anythingMerged = false;
        for (int slot : slots) {
            if (stack.func_190926_b()) break;
            anythingMerged |= this.mergeWithSlot(inv, stack, slot);
        }
        return anythingMerged;
    }

    public boolean mergeWithSlots(@Nonnull IInventory inv, @Nullable ItemStack stack) {
        if (ItemUtils.isEmpty(stack)) {
            return false;
        }
        boolean anythingMerged = false;
        for (int i = 0; i < inv.func_70302_i_() && !stack.func_190926_b(); ++i) {
            anythingMerged |= this.mergeWithSlot(inv, stack, i);
        }
        return anythingMerged;
    }

    public ItemStack mergeWithSlotsStack(@Nonnull IInventory inv, @Nullable ItemStack stack) {
        if (ItemUtils.isEmpty(stack)) {
            return ItemStack.field_190927_a;
        }
        for (int i = 0; i < inv.func_70302_i_() && !stack.func_190926_b(); ++i) {
            this.mergeWithSlot(inv, stack, i);
        }
        return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
    }

    public boolean clearSlots(@Nonnull IInventory inv, int[] src) {
        boolean clearedAnything = false;
        for (int slot : src) {
            clearedAnything |= !ItemUtils.isEmpty(inv.func_70304_b(slot));
        }
        return clearedAnything;
    }

    public boolean clearSlots(@Nonnull IInventory inv) {
        boolean clearedAnything = false;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            clearedAnything |= !ItemUtils.isEmpty(inv.func_70304_b(i));
        }
        return clearedAnything;
    }

    public ItemStack yankSlot(@Nonnull IInventory inv, int slot) {
        ItemStack stack = inv.func_70301_a(slot);
        if (!ItemUtils.isEmpty(stack)) {
            return inv.func_70298_a(slot, stack.func_190916_E());
        }
        return ItemStack.field_190927_a;
    }

    protected boolean checkItemEquality(ItemStack actual, ItemStack expected) {
        if (ItemUtils.isEmpty(actual)) {
            return false;
        }
        return expected.func_77969_a(actual);
    }

    public boolean checkSlot(@Nonnull IInventory inv, @Nullable ItemStack expected, int src) {
        ItemStack actual = inv.func_70301_a(src);
        return !(ItemUtils.isEmpty(expected) ? !ItemUtils.isEmpty(actual) : !this.checkItemEquality(actual, expected));
    }

    public boolean checkSlotAndSize(@Nonnull IInventory inv, @Nullable ItemStack expected, int src) {
        ItemStack actual = inv.func_70301_a(src);
        if (ItemUtils.isEmpty(expected)) {
            if (!ItemUtils.isEmpty(actual)) {
                return false;
            }
        } else {
            if (!this.checkItemEquality(actual, expected)) {
                return false;
            }
            if (actual.func_190916_E() < expected.func_190916_E()) {
                return false;
            }
        }
        return true;
    }

    public boolean checkSlotAndSize(@Nonnull IInventory inv, @Nullable IMultiItemStacks expected, int src) {
        ItemStack actual = inv.func_70301_a(src);
        if (ItemUtils.isEmpty(expected)) {
            if (!ItemUtils.isEmpty(actual)) {
                return false;
            }
        } else {
            if (ItemUtils.isEmpty(actual)) {
                return false;
            }
            if (!expected.containsItemStack(actual)) {
                return false;
            }
            if (actual.func_190916_E() < expected.getStackSize()) {
                return false;
            }
        }
        return true;
    }

    public boolean checkSlotsAndSizes(@Nonnull IInventory inv, @Nonnull ItemStack[] filter, int[] from) {
        assert (filter.length == from.length);
        for (int i = 0; i < filter.length; ++i) {
            if (this.checkSlotAndSize(inv, filter[i], from[i])) continue;
            return false;
        }
        return true;
    }

    public boolean checkSlotsAndSizes(@Nonnull IInventory inv, @Nonnull IMultiItemStacks[] filter, int[] from) {
        assert (filter.length == from.length);
        for (int i = 0; i < filter.length; ++i) {
            if (this.checkSlotAndSize(inv, filter[i], from[i])) continue;
            return false;
        }
        return true;
    }

    public boolean checkSlotsAndSizes(@Nonnull IInventory inv, @Nonnull List filter, int[] from) {
        assert (filter.size() == from.length);
        for (int i = 0; i < filter.size(); ++i) {
            Object filterObject = filter.get(i);
            if (filterObject instanceof IMultiItemStacks) {
                if (this.checkSlotAndSize(inv, (IMultiItemStacks)filterObject, from[i])) continue;
                return false;
            }
            if (filterObject instanceof ItemStack || filterObject == null) {
                if (this.checkSlotAndSize(inv, (ItemStack)filterObject, from[i])) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    public boolean moveToSlots(@Nonnull IInventory inv, @Nonnull ItemStack[] filter, int[] from, int[] to) {
        assert (filter.length == from.length);
        assert (filter.length == to.length);
        if (!this.checkSlotsAndSizes(inv, filter, from)) {
            return false;
        }
        for (int i = 0; i < filter.length; ++i) {
            if (ItemUtils.isEmpty(filter[i])) continue;
            ItemStack stack = inv.func_70298_a(from[i], filter[i].func_190916_E());
            inv.func_70299_a(to[i], stack);
        }
        return true;
    }

    public boolean moveToSlots(@Nonnull IInventory inv, @Nonnull IMultiItemStacks[] filter, int[] from, int[] to) {
        assert (filter.length == from.length);
        assert (filter.length == to.length);
        if (!this.checkSlotsAndSizes(inv, filter, from)) {
            return false;
        }
        for (int i = 0; i < filter.length; ++i) {
            if (ItemUtils.isEmpty(filter[i])) continue;
            ItemStack stack = inv.func_70298_a(from[i], filter[i].getStackSize());
            inv.func_70299_a(to[i], stack);
        }
        return true;
    }

    public boolean moveToSlot(@Nonnull IInventory inv, @Nonnull ItemStack filter, int from, int to) {
        if (!this.checkSlotAndSize(inv, filter, from)) {
            return false;
        }
        ItemStack stack = inv.func_70298_a(from, filter.func_190916_E());
        inv.func_70299_a(to, stack);
        return true;
    }

    public int findItemSlot(@Nonnull IInventory inv, @Nonnull Item query) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (ItemUtils.isEmpty(stack) || stack.func_77973_b() != query) continue;
            return i;
        }
        return -1;
    }

    public int findItemSlot(@Nonnull IInventory inv, @Nonnull ItemStack query) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (ItemUtils.isEmpty(query) && ItemUtils.isEmpty(stack)) {
                return i;
            }
            if (ItemUtils.isEmpty(query) || ItemUtils.isEmpty(stack) || !query.func_77969_a(stack)) continue;
            return i;
        }
        return -1;
    }

    public int[] findItemSlots(@Nonnull IInventory inv, @Nonnull List expected, @Nonnull int[] slotsSlice) {
        boolean[] usedSlots = new boolean[inv.func_70302_i_()];
        int[] slots = new int[expected.size()];
        int i = 0;
        int invSize = slotsSlice != null ? slotsSlice.length : inv.func_70302_i_();
        for (Object expectedStack : expected) {
            slots[i] = -1;
            for (int index = 0; index < invSize; ++index) {
                int slotIndex = slotsSlice != null ? slotsSlice[index] : index;
                boolean foundItem = false;
                if (expectedStack instanceof IMultiItemStacks) {
                    foundItem = this.checkSlotAndSize(inv, (IMultiItemStacks)expectedStack, slotIndex);
                } else if (expectedStack instanceof ItemStack) {
                    foundItem = this.checkSlotAndSize(inv, (ItemStack)expectedStack, slotIndex);
                }
                if (!foundItem || usedSlots[slotIndex]) continue;
                usedSlots[slotIndex] = true;
                slots[i] = slotIndex;
                break;
            }
            ++i;
        }
        return slots;
    }

    public int[] findItemSlots(@Nonnull IInventory inv, @Nonnull List expected) {
        return this.findItemSlots(inv, expected, null);
    }

    public int findNextEmpty(@Nonnull IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (!ItemUtils.isEmpty(inv.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    public int findNextEmptyFromEnd(@Nonnull IInventory inv) {
        for (int i = inv.func_70302_i_() - 1; i >= 0; --i) {
            if (!ItemUtils.isEmpty(inv.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    public int findNextPresent(@Nonnull IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (ItemUtils.isEmpty(inv.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    public int findNextPresentFromEnd(@Nonnull IInventory inv) {
        for (int i = inv.func_70302_i_() - 1; i >= 0; --i) {
            if (ItemUtils.isEmpty(inv.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    public boolean checkSlotsAndSizesUnordered(@Nonnull IInventory inv, @Nonnull List filter, int[] from) {
        int[] slots;
        assert (filter.size() == from.length);
        for (int i : slots = this.findItemSlots(inv, filter, from)) {
            if (i >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean checkSlotsAndSizesUnordered(@Nonnull IInventory inv, @Nonnull ItemStack[] filter, int[] from) {
        return this.checkSlotsAndSizesUnordered(inv, Arrays.asList(filter), from);
    }

    public boolean checkSlotsAndSizesUnordered(@Nonnull IInventory inv, @Nonnull IMultiItemStacks[] filter, int[] from) {
        return this.checkSlotsAndSizesUnordered(inv, Arrays.asList(filter), from);
    }

    public boolean slotsAreValid(@Nonnull IInventory inv, @Nonnull int[] slots) {
        for (int slot : slots) {
            if (slot < 0) {
                return false;
            }
            if (slot < inv.func_70302_i_()) continue;
            return false;
        }
        return true;
    }

    public boolean consumeItemsInSlots(@Nonnull IInventory inv, @Nonnull List expected, @Nonnull int[] slots) {
        for (int i = 0; i < slots.length; ++i) {
            int slot = slots[i];
            Object expectedStack = expected.get(i);
            if (expectedStack == null) continue;
            if (expectedStack instanceof IMultiItemStacks) {
                inv.func_70298_a(slot, ((IMultiItemStacks)expectedStack).getStackSize());
                continue;
            }
            if (!(expectedStack instanceof ItemStack)) continue;
            inv.func_70298_a(slot, ((ItemStack)expectedStack).func_190916_E());
        }
        return true;
    }

    public boolean consumeItems(@Nonnull IInventory inv, @Nonnull List expected) {
        int[] slots = this.findItemSlots(inv, expected);
        if (!this.checkSlotsAndSizes(inv, expected, slots)) {
            return false;
        }
        return this.consumeItemsInSlots(inv, expected, slots);
    }

    public boolean canInsertItem(@Nonnull IInventory inv, @Nullable ItemStack stack, int slot) {
        ItemStack expected = inv.func_70301_a(slot);
        if (!ItemUtils.isEmpty(expected)) {
            if (!this.checkSlot(inv, stack, slot)) {
                return false;
            }
            if (expected.func_190916_E() >= inv.func_70297_j_()) {
                return false;
            }
            int estSize = expected.func_190916_E() + stack.func_190916_E();
            return estSize <= inv.func_70297_j_();
        }
        return true;
    }

    public boolean canExtractItem(@Nonnull IInventory inv, @Nullable ItemStack stack, int slot) {
        ItemStack expected = inv.func_70301_a(slot);
        if (ItemUtils.isEmpty(expected)) {
            return false;
        }
        return this.checkSlotAndSize(inv, stack, slot);
    }

    public static InventoryProcessor instance() {
        return inst;
    }
}

