/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.core.shared.utils;

import growthcraft.core.shared.io.nbt.INBTSerializableContext;
import growthcraft.core.shared.io.stream.IStreamable;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PulseStepper
implements INBTSerializableContext,
IStreamable {
    public int maxLoops;
    public int loops;
    public int maxSteps;
    public int steps;

    public PulseStepper(int mxSteps, int mxLoops) {
        this.maxSteps = mxSteps;
        this.maxLoops = mxLoops;
    }

    public PulseStepper(int mxSteps) {
        this(mxSteps, 0);
    }

    public PulseStepper() {
        this(1);
    }

    public void setMaxLoops(int mx) {
        this.maxLoops = mx;
    }

    public void setMaxSteps(int mx) {
        this.maxSteps = mx;
    }

    public void resetLoops() {
        this.loops = 0;
    }

    public void resetSteps() {
        this.steps = 0;
    }

    public void reset() {
        this.resetLoops();
        this.resetSteps();
    }

    public void clear() {
        this.maxLoops = 0;
        this.loops = 0;
        this.maxSteps = 0;
        this.steps = 0;
    }

    public State update() {
        if (this.maxLoops > 0 && this.loops >= this.maxLoops) {
            return State.NONE;
        }
        ++this.steps;
        if (this.steps >= this.maxSteps) {
            this.resetSteps();
            ++this.loops;
            return State.PULSE;
        }
        return State.TICK;
    }

    private void readFromNBT(NBTTagCompound data) {
        this.maxLoops = data.func_74762_e("max_loops");
        this.loops = data.func_74762_e("loops");
        this.maxSteps = data.func_74762_e("max_steps");
        this.steps = data.func_74762_e("steps");
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String name) {
        if (data.func_74764_b(name)) {
            this.readFromNBT(data.func_74775_l(name));
        }
    }

    private void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("max_loops", this.maxLoops);
        data.func_74768_a("loops", this.loops);
        data.func_74768_a("max_steps", this.maxSteps);
        data.func_74768_a("steps", this.steps);
    }

    @Override
    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        data.func_74782_a(name, (NBTBase)tag);
    }

    @Override
    public boolean readFromStream(ByteBuf stream) {
        this.maxLoops = stream.readInt();
        this.loops = stream.readInt();
        this.maxSteps = stream.readInt();
        this.steps = stream.readInt();
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf stream) {
        stream.writeInt(this.maxLoops);
        stream.writeInt(this.loops);
        stream.writeInt(this.maxSteps);
        stream.writeInt(this.steps);
        return false;
    }

    public static enum State {
        NONE,
        TICK,
        PULSE;

    }
}

