/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.hops.common;

import growthcraft.cellar.shared.GrowthcraftCellarApis;
import growthcraft.cellar.shared.booze.BoozeRegistryHelper;
import growthcraft.cellar.shared.booze.BoozeTag;
import growthcraft.cellar.shared.booze.BoozeUtils;
import growthcraft.cellar.shared.config.GrowthcraftCellarConfig;
import growthcraft.cellar.shared.definition.BlockBoozeDefinition;
import growthcraft.cellar.shared.definition.BoozeDefinition;
import growthcraft.cellar.shared.fluids.Booze;
import growthcraft.cellar.shared.item.ItemBoozeBottle;
import growthcraft.cellar.shared.processing.common.Residue;
import growthcraft.core.GrowthcraftCore;
import growthcraft.core.shared.GrowthcraftCoreApis;
import growthcraft.core.shared.client.render.utils.ItemRenderUtils;
import growthcraft.core.shared.definition.BlockDefinition;
import growthcraft.core.shared.definition.ItemDefinition;
import growthcraft.core.shared.definition.ItemTypeDefinition;
import growthcraft.core.shared.effect.EffectAddPotionEffect;
import growthcraft.core.shared.effect.EffectWeightedRandomList;
import growthcraft.core.shared.effect.SimplePotionEffectFactory;
import growthcraft.core.shared.item.OreItemStacks;
import growthcraft.core.shared.utils.TickUtils;
import growthcraft.hops.common.block.BlockHops;
import growthcraft.hops.common.item.ItemHops;
import growthcraft.hops.common.item.ItemSeedHops;
import growthcraft.hops.shared.config.GrowthcraftHopsConfig;
import growthcraft.hops.shared.init.GrowthcraftHopsBlocks;
import growthcraft.hops.shared.init.GrowthcraftHopsFluids;
import growthcraft.hops.shared.init.GrowthcraftHopsItems;
import growthcraft.hops.shared.init.GrowthcraftHopsLootTables;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;

public class Init {
    private Init() {
    }

    public static void preInitBlocks() {
        GrowthcraftHopsBlocks.hops = new BlockDefinition((Block)new BlockHops("hops"));
        GrowthcraftHopsBlocks.hopAleFluidBlocks = null;
        GrowthcraftHopsBlocks.lagerFluidBlocks = null;
    }

    public static void registerBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftHopsBlocks.hops.registerBlock(registry);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRenders() {
    }

    public static void preInitItems() {
        GrowthcraftHopsItems.hops = new ItemDefinition(new ItemHops("hops"));
        GrowthcraftHopsItems.hop_seeds = new ItemDefinition((Item)new ItemSeedHops("hop_seeds"));
        GrowthcraftHopsItems.lagerBottle = new ItemTypeDefinition<ItemBoozeBottle>(new ItemBoozeBottle());
        GrowthcraftHopsItems.hopAleBottle = new ItemTypeDefinition<ItemBoozeBottle>(new ItemBoozeBottle());
    }

    public static void registerItemOres() {
        OreDictionary.registerOre((String)"cropHops", GrowthcraftHopsItems.hops.getItem());
    }

    public static void registerItems(IForgeRegistry<Item> registry) {
        GrowthcraftHopsItems.hops.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftHopsItems.hops.registerItem(registry);
        GrowthcraftHopsItems.hop_seeds.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftHopsItems.hop_seeds.registerItem(registry);
        GrowthcraftHopsItems.lagerBottle.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftHopsItems.lagerBottle.getItem().setBoozes(GrowthcraftHopsFluids.lagerBooze);
        GrowthcraftHopsItems.lagerBottle.registerItem(registry, new ResourceLocation("growthcraft_hops", "lager"));
        GrowthcraftHopsItems.hopAleBottle.getItem().func_77637_a(GrowthcraftCoreApis.tabGrowthcraft);
        GrowthcraftHopsItems.hopAleBottle.getItem().setBoozes(GrowthcraftHopsFluids.hopAleBooze);
        GrowthcraftHopsItems.hopAleBottle.registerItem(registry, new ResourceLocation("growthcraft_hops", "hopale"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenders() {
        GrowthcraftHopsItems.hops.registerRender();
        GrowthcraftHopsItems.hop_seeds.registerRender();
        GrowthcraftHopsItems.lagerBottle.registerRenders(GrowthcraftHopsItems.LagerTypes.class);
        GrowthcraftHopsItems.hopAleBottle.registerRenders(GrowthcraftHopsItems.HopAleTypes.class);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemColorHandlers() {
        ItemRenderUtils.registerItemColorHandler((Item)GrowthcraftHopsItems.lagerBottle.getItem());
        ItemRenderUtils.registerItemColorHandler((Item)GrowthcraftHopsItems.hopAleBottle.getItem());
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemVariants() {
        GrowthcraftHopsItems.lagerBottle.registerModelBakeryVariants(GrowthcraftHopsItems.LagerTypes.class);
        GrowthcraftHopsItems.hopAleBottle.registerModelBakeryVariants(GrowthcraftHopsItems.HopAleTypes.class);
    }

    public static void preInitFluids() {
        GrowthcraftHopsFluids.lagerBooze = new BoozeDefinition[GrowthcraftHopsItems.LagerTypes.values().length];
        BoozeRegistryHelper.initializeAndRegisterBoozeFluids(GrowthcraftHopsFluids.lagerBooze, GrowthcraftHopsItems.LagerTypes.class, "lager");
        for (BoozeDefinition booze : GrowthcraftHopsFluids.lagerBooze) {
            ((Booze)booze.getFluid()).setColor(GrowthcraftHopsConfig.lagerColor).setDensity(1080);
        }
        GrowthcraftHopsFluids.hopAleBooze = new BoozeDefinition[GrowthcraftHopsItems.HopAleTypes.values().length];
        BoozeRegistryHelper.initializeAndRegisterBoozeFluids(GrowthcraftHopsFluids.hopAleBooze, GrowthcraftHopsItems.HopAleTypes.class, "hopale");
        for (BoozeDefinition booze : GrowthcraftHopsFluids.hopAleBooze) {
            ((Booze)booze.getFluid()).setColor(GrowthcraftHopsConfig.hopAleColor).setDensity(1080);
        }
    }

    public static void registerFluidBlocks(IForgeRegistry<Block> registry) {
        GrowthcraftHopsBlocks.lagerFluidBlocks = new BlockBoozeDefinition[GrowthcraftHopsFluids.lagerBooze.length];
        BoozeRegistryHelper.initializeBooze(GrowthcraftHopsFluids.lagerBooze, GrowthcraftHopsBlocks.lagerFluidBlocks);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftHopsFluids.lagerBooze, 1, -0.6f);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftHopsFluids.lagerBooze[GrowthcraftHopsItems.LagerTypes.LAGER_YOUNG.ordinal()], 1, 0.3f);
        BoozeRegistryHelper.registerBoozeBlocks(registry, GrowthcraftHopsFluids.lagerBooze, GrowthcraftHopsBlocks.lagerFluidBlocks, "growthcraft_hops", "lagerbooze", GrowthcraftHopsItems.LagerTypes.class);
        GrowthcraftHopsBlocks.hopAleFluidBlocks = new BlockBoozeDefinition[GrowthcraftHopsFluids.hopAleBooze.length];
        BoozeRegistryHelper.initializeBooze(GrowthcraftHopsFluids.hopAleBooze, GrowthcraftHopsBlocks.hopAleFluidBlocks);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftHopsFluids.hopAleBooze, 1, -0.6f);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_UNHOPPED.ordinal()], 1, 0.3f);
        BoozeRegistryHelper.setBoozeFoodStats(GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_YOUNG.ordinal()], 1, 0.3f);
        BoozeRegistryHelper.registerBoozeBlocks(registry, GrowthcraftHopsFluids.hopAleBooze, GrowthcraftHopsBlocks.hopAleFluidBlocks, "growthcraft_hops", "hopalebooze", GrowthcraftHopsItems.HopAleTypes.class);
    }

    public static void initBoozes() {
        BoozeRegistryHelper.initBoozeContainers(GrowthcraftHopsFluids.hopAleBooze, GrowthcraftHopsItems.hopAleBottle, "growthcraft_hops", "hopalebooze", GrowthcraftHopsItems.HopAleTypes.class);
        BoozeRegistryHelper.initBoozeContainers(GrowthcraftHopsFluids.lagerBooze, GrowthcraftHopsItems.lagerBottle, "growthcraft_hops", "lagerbooze", GrowthcraftHopsItems.LagerTypes.class);
        Init.registerFermentations();
    }

    private static void registerLagerFermentations() {
        int fermentTime = GrowthcraftCellarConfig.fermentTime;
        FluidStack[] fs = new FluidStack[GrowthcraftHopsFluids.lagerBooze.length];
        for (int i = 0; i < GrowthcraftHopsFluids.lagerBooze.length; ++i) {
            fs[i] = GrowthcraftHopsFluids.lagerBooze[i].asFluidStack();
        }
        FluidStack[] spoilInputFs = new FluidStack[GrowthcraftHopsFluids.lagerBooze.length];
        for (int i = 0; i < GrowthcraftHopsFluids.lagerBooze.length; ++i) {
            spoilInputFs[i] = GrowthcraftHopsFluids.lagerBooze[i].asFluidStack(40);
        }
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.lagerBooze[GrowthcraftHopsItems.LagerTypes.LAGER_YOUNG.ordinal()].getFluid()).tags(BoozeTag.YOUNG, BoozeTag.CHILLED).brewsFrom(new FluidStack(GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_YOUNG.ordinal()].getFluid(), 40), new OreItemStacks("yeastLager"), false, TickUtils.minutes(1), Residue.newDefault(0.0f));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.lagerBooze[GrowthcraftHopsItems.LagerTypes.LAGER_NORMAL.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_YOUNG.ordinal()], new OreItemStacks("yeastBrewers"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_YOUNG.ordinal()], new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76424_c, TickUtils.seconds(90), 0).addPotionEntry(MobEffects.field_76422_e, TickUtils.seconds(90), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.lagerBooze[GrowthcraftHopsItems.LagerTypes.LAGER_POTENT.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.POTENT).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_NORMAL.ordinal()], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_EXTENDED.ordinal()], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76424_c, TickUtils.seconds(90), 0).addPotionEntry(MobEffects.field_76422_e, TickUtils.seconds(90), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.lagerBooze[GrowthcraftHopsItems.LagerTypes.LAGER_EXTENDED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.EXTENDED).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_NORMAL.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_POTENT.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76424_c, TickUtils.seconds(90), 0).addPotionEntry(MobEffects.field_76422_e, TickUtils.seconds(90), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.lagerBooze[GrowthcraftHopsItems.LagerTypes.LAGER_HYPEREXTENDED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_POTENT.ordinal()], new OreItemStacks("yeastEthereal"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_EXTENDED.ordinal()], new OreItemStacks("yeastEthereal"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76424_c, TickUtils.seconds(90), 0).addPotionEntry(MobEffects.field_76422_e, TickUtils.seconds(90), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.lagerBooze[GrowthcraftHopsItems.LagerTypes.LAGER_INTOXICATED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.INTOXICATED).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_POTENT.ordinal()], new OreItemStacks("yeastOrigin"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_EXTENDED.ordinal()], new OreItemStacks("yeastOrigin"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.091f), TickUtils.seconds(45)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76422_e, TickUtils.minutes(3), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76419_f, TickUtils.minutes(3), 2)))).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76424_c, TickUtils.minutes(3), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76421_d, TickUtils.minutes(3), 2))));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.lagerBooze[GrowthcraftHopsItems.LagerTypes.LAGER_POISONED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.CHILLED, BoozeTag.POISONED).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_NORMAL.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.LagerTypes.LAGER_NORMAL.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.LagerTypes.LAGER_NORMAL.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_POTENT.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.LagerTypes.LAGER_POTENT.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.LagerTypes.LAGER_POTENT.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_EXTENDED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.LagerTypes.LAGER_EXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.LagerTypes.LAGER_EXTENDED.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_HYPEREXTENDED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.LagerTypes.LAGER_HYPEREXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.LagerTypes.LAGER_HYPEREXTENDED.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.LagerTypes.LAGER_INTOXICATED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.LagerTypes.LAGER_INTOXICATED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.LagerTypes.LAGER_INTOXICATED.ordinal()], TickUtils.minutes(1), null).fermentsFromFallback(fs[GrowthcraftHopsItems.LagerTypes.LAGER_POISONED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.LagerTypes.LAGER_POISONED.ordinal()], TickUtils.minutes(1), null).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.0419f), TickUtils.seconds(45)).createPotionEntry(MobEffects.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthcraftCore.config.getHidePoisonedBooze());
    }

    private static void registerHopAleFermentations() {
        int fermentTime = GrowthcraftCellarConfig.fermentTime;
        FluidStack[] fs = new FluidStack[GrowthcraftHopsFluids.hopAleBooze.length];
        for (int i = 0; i < GrowthcraftHopsFluids.hopAleBooze.length; ++i) {
            fs[i] = GrowthcraftHopsFluids.hopAleBooze[i].asFluidStack();
        }
        FluidStack[] spoilInputFs = new FluidStack[GrowthcraftHopsFluids.hopAleBooze.length];
        for (int i = 0; i < GrowthcraftHopsFluids.hopAleBooze.length; ++i) {
            spoilInputFs[i] = GrowthcraftHopsFluids.hopAleBooze[i].asFluidStack(40);
        }
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_YOUNG.ordinal()].getFluid()).tags(BoozeTag.YOUNG).brewsFrom(new FluidStack(FluidRegistry.WATER, 40), new OreItemStacks("cropWheat"), false, TickUtils.minutes(1), Residue.newDefault(0.3f));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_UNHOPPED.ordinal()].getFluid()).tags(BoozeTag.YOUNG, BoozeTag.HOPPED).brewsFrom(new FluidStack(GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_YOUNG.ordinal()].getFluid(), 40), new OreItemStacks("cropHops"), false, TickUtils.minutes(1), Residue.newDefault(0.0f));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_NORMAL.ordinal()].getFluid()).tags(BoozeTag.FERMENTED).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_UNHOPPED.ordinal()], new OreItemStacks("yeastBrewers"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_UNHOPPED.ordinal()], new ItemStack(Items.field_151075_bm), (int)((double)fermentTime * 0.66)).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76422_e, TickUtils.minutes(3), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_POTENT.ordinal()].getFluid()).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.POTENT).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_NORMAL.ordinal()], new OreItemStacks("dustGlowstone"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_EXTENDED.ordinal()], new OreItemStacks("dustGlowstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.12f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76422_e, TickUtils.minutes(3), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_EXTENDED.ordinal()].getFluid()).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.EXTENDED).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_NORMAL.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_POTENT.ordinal()], new OreItemStacks("dustRedstone"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76422_e, TickUtils.minutes(3), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_HYPEREXTENDED.ordinal()].getFluid()).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.HYPER_EXTENDED).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_POTENT.ordinal()], new OreItemStacks("yeastEthereal"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_EXTENDED.ordinal()], new OreItemStacks("yeastEthereal"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76422_e, TickUtils.minutes(3), 0);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_LAGER.ordinal()].getFluid()).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.CHILLED).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_HYPEREXTENDED.ordinal()], new OreItemStacks("yeastLager"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.071f), TickUtils.seconds(45)).addPotionEntry(MobEffects.field_76422_e, TickUtils.minutes(10), 2);
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_INTOXICATED.ordinal()].getFluid()).tags(BoozeTag.HOPPED, BoozeTag.FERMENTED, BoozeTag.INTOXICATED).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_POTENT.ordinal()], new OreItemStacks("yeastOrigin"), fermentTime).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_EXTENDED.ordinal()], new OreItemStacks("yeastOrigin"), fermentTime).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.2f), TickUtils.seconds(45)).addEffect(new EffectWeightedRandomList().add(8, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76422_e, TickUtils.minutes(3), 2))).add(2, new EffectAddPotionEffect(new SimplePotionEffectFactory(MobEffects.field_76419_f, TickUtils.minutes(3), 2))));
        GrowthcraftCellarApis.boozeBuilderFactory.create((Fluid)GrowthcraftHopsFluids.hopAleBooze[GrowthcraftHopsItems.HopAleTypes.ALE_POISONED.ordinal()].getFluid()).tags(BoozeTag.FERMENTED, BoozeTag.POISONED).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_NORMAL.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.HopAleTypes.ALE_NORMAL.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.HopAleTypes.ALE_NORMAL.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_POTENT.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.HopAleTypes.ALE_POTENT.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.HopAleTypes.ALE_POTENT.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_EXTENDED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.HopAleTypes.ALE_EXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.HopAleTypes.ALE_EXTENDED.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_HYPEREXTENDED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.HopAleTypes.ALE_HYPEREXTENDED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.HopAleTypes.ALE_HYPEREXTENDED.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_LAGER.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.HopAleTypes.ALE_LAGER.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.HopAleTypes.ALE_LAGER.ordinal()], TickUtils.minutes(1), null).fermentsFrom(fs[GrowthcraftHopsItems.HopAleTypes.ALE_INTOXICATED.ordinal()], new OreItemStacks("yeastPoison"), fermentTime).fermentsFromFallback(fs[GrowthcraftHopsItems.HopAleTypes.ALE_INTOXICATED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.HopAleTypes.ALE_INTOXICATED.ordinal()], TickUtils.minutes(1), null).fermentsFromFallback(fs[GrowthcraftHopsItems.HopAleTypes.ALE_POISONED.ordinal()], fermentTime).brewsFromFallback(spoilInputFs[GrowthcraftHopsItems.HopAleTypes.ALE_POISONED.ordinal()], TickUtils.minutes(1), null).getEffect().setTipsy(BoozeUtils.alcoholToTipsy(0.1f), TickUtils.seconds(45)).createPotionEntry(MobEffects.field_76436_u, TickUtils.seconds(90), 0).toggleDescription(!GrowthcraftCore.config.getHidePoisonedBooze());
    }

    private static void registerFermentations() {
        Init.registerHopAleFermentations();
        Init.registerLagerFermentations();
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerFluidRenders() {
        BoozeRegistryHelper.registerBoozeRenderers(GrowthcraftHopsFluids.lagerBooze, GrowthcraftHopsBlocks.lagerFluidBlocks);
        BoozeRegistryHelper.registerBoozeRenderers(GrowthcraftHopsFluids.hopAleBooze, GrowthcraftHopsBlocks.hopAleFluidBlocks);
    }

    public static void registerRecipes() {
        Init.registerCraftingRecipes();
    }

    private static void registerCraftingRecipes() {
    }

    public static void preInitLootTables() {
        GrowthcraftHopsLootTables.registerLootTables();
    }
}

