/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.block;

import growthcraft.core.shared.block.GrowthcraftRotatableBlockContainer;
import growthcraft.milk.common.tileentity.TileEntityButterChurn;
import growthcraft.milk.shared.init.GrowthcraftMilkBlocks;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockButterChurn
extends GrowthcraftRotatableBlockContainer {
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockButterChurn(String unlocalizedName) {
        super(Material.field_151575_d);
        this.func_149663_c(unlocalizedName);
        this.setRegistryName(new ResourceLocation("growthcraft_milk", unlocalizedName));
        this.func_149752_b(5.0f);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setTileEntityType(TileEntityButterChurn.class);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        BlockButterChurn.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BOUNDING_BOX);
    }

    private Block getPlungerBlock() {
        return GrowthcraftMilkBlocks.churnPlunger.getBlock();
    }

    @Override
    public void doRotateBlock(World world, BlockPos pos, IBlockState state, EnumFacing side) {
        IBlockState statePlunger = world.func_180495_p(pos.func_177984_a());
        EnumFacing churnFacing = (EnumFacing)state.func_177229_b((IProperty)TYPE_ROTATION);
        world.func_180501_a(pos, state.func_177226_a((IProperty)TYPE_ROTATION, (Comparable)churnFacing), 2);
        world.func_180501_a(pos.func_177984_a(), statePlunger.func_177226_a((IProperty)TYPE_ROTATION, (Comparable)churnFacing), 2);
    }

    private void placePlungerFor(World world, BlockPos pos, EnumFacing facing) {
        IBlockState statePlunger = this.getPlungerBlock().func_176223_P().func_177226_a((IProperty)TYPE_ROTATION, (Comparable)facing);
        world.func_180501_a(pos.func_177984_a(), statePlunger, 2);
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean tryChurning(World world, BlockPos pos, EntityPlayer player) {
        TileEntityButterChurn butterChurn = (TileEntityButterChurn)this.getTileEntity((IBlockAccess)world, pos);
        if (butterChurn != null) {
            switch (butterChurn.doWork()) {
                case CHURN: 
                case PRODUCE: {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, facing, hitX, hitY, hitZ)) {
            return true;
        }
        return !playerIn.func_70093_af() && this.tryChurning(worldIn, pos, playerIn);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)TYPE_ROTATION);
        this.placePlungerFor(world, pos, facing);
    }

    @Override
    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.func_180633_a(worldIn, pos, state, placer, stack);
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)TYPE_ROTATION);
        this.placePlungerFor(worldIn, pos, facing);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d && this.plungerIsAbove((IBlockAccess)world, pos)) {
            world.func_175655_b(pos.func_177984_a(), false);
            TileEntity te = world.func_175625_s(pos.func_177984_a());
            if (te != null) {
                te.func_145843_s();
            }
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canBlockStay((IBlockAccess)worldIn, pos)) {
            worldIn.func_175655_b(pos, true);
        }
    }

    public boolean plungerIsAbove(IBlockAccess world, BlockPos pos) {
        return this.getPlungerBlock() == world.func_180495_p(pos.func_177984_a()).func_177230_c();
    }

    public boolean canBlockStay(IBlockAccess world, BlockPos pos) {
        return this.plungerIsAbove(world, pos);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        if (pos.func_177956_o() >= 255) {
            return false;
        }
        return world.func_180495_p(pos.func_177977_b()).func_185896_q() && super.func_176196_c(world, pos) && super.func_176196_c(world, pos.func_177984_a());
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return 0;
    }
}

