/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity;

import growthcraft.core.shared.fluids.FluidTest;
import growthcraft.core.shared.tileentity.GrowthcraftTileDeviceBase;
import growthcraft.core.shared.tileentity.device.DeviceBase;
import growthcraft.core.shared.tileentity.feature.IFluidTankOperable;
import growthcraft.core.shared.tileentity.feature.ITileProgressiveDevice;
import growthcraft.milk.common.tileentity.IPancheonTile;
import growthcraft.milk.common.tileentity.device.Pancheon;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class TileEntityPancheon
extends GrowthcraftTileDeviceBase
implements ITickable,
ITileProgressiveDevice,
IPancheonTile {
    private Pancheon pancheon = new Pancheon(this, 0, 2, 1);

    @Override
    public DeviceBase[] getDevices() {
        return new DeviceBase[]{this.pancheon};
    }

    @Override
    public float getDeviceProgress() {
        return this.pancheon.getProgress();
    }

    @Override
    public int getDeviceProgressScaled(int scale) {
        return this.pancheon.getProgressScaled(scale);
    }

    @Override
    protected FluidTank[] createTanks() {
        return new FluidTank[]{new FluidTank(1000), new FluidTank(1000), new FluidTank(1000)};
    }

    protected int getPresentTankIndex() {
        for (int i = this.getTankCount() - 1; i > 0; --i) {
            if (!this.isFluidTankFilled(i)) continue;
            return i;
        }
        return 0;
    }

    public FluidTank getPresentTank() {
        return this.getFluidTank(this.getPresentTankIndex());
    }

    public boolean outputTanksHaveFluid() {
        return this.isFluidTankFilled(1) || this.isFluidTankFilled(2);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            this.pancheon.update();
        }
    }

    @Override
    protected FluidStack doDrain(EnumFacing dir, int amount, boolean doDrain) {
        return this.getPresentTank().drain(amount, doDrain);
    }

    @Override
    protected FluidStack doDrain(EnumFacing dir, FluidStack stack, boolean doDrain) {
        if (!FluidTest.isValid(stack)) {
            return null;
        }
        FluidTank tank = this.getPresentTank();
        FluidStack expected = tank.getFluid();
        if (expected != null && expected.isFluidEqual(stack)) {
            return tank.drain(stack.amount, doDrain);
        }
        return null;
    }

    @Override
    protected int doFill(EnumFacing dir, FluidStack stack, boolean doFill) {
        if (this.outputTanksHaveFluid()) {
            return 0;
        }
        return this.fillFluidTank(0, stack, doFill);
    }

    @Override
    protected void markFluidDirty() {
        super.markFluidDirty();
        this.markDirtyAndUpdate(true);
    }

    @Override
    public IFluidTankOperable getPancheonFluidHandler() {
        return this;
    }
}

