/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.milk.common.tileentity.struct;

import growthcraft.core.shared.io.stream.IStreamable;
import growthcraft.milk.GrowthcraftMilk;
import growthcraft.milk.shared.MilkRegistry;
import growthcraft.milk.shared.cheese.CheeseIO;
import growthcraft.milk.shared.cheese.CheeseUtils;
import growthcraft.milk.shared.definition.EnumCheeseStage;
import growthcraft.milk.shared.definition.ICheeseType;
import growthcraft.milk.shared.init.GrowthcraftMilkItems;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;

public class Cheese
implements IStreamable {
    public boolean needClientUpdate = true;
    private int ageMax = 1200;
    private int age;
    private int topSlicesMax = 4;
    private int topSlices = 4;
    private boolean isDoubleStacked = false;
    private static final int CHEESE_PER_SLICE = 4;
    private ICheeseType cheese = GrowthcraftMilkItems.WaxedCheeseTypes.CHEDDAR;
    private EnumCheeseStage cheeseStage = EnumCheeseStage.UNWAXED;

    public ICheeseType getType() {
        return this.cheese;
    }

    public EnumCheeseStage getStage() {
        return this.cheeseStage;
    }

    public Cheese setStage(EnumCheeseStage stage) {
        this.cheeseStage = stage;
        this.needClientUpdate = true;
        return this;
    }

    public Cheese setDoubleStacked(boolean isDoubleStacked) {
        if (this.isDoubleStacked != isDoubleStacked) {
            this.age = 0;
            this.isDoubleStacked = isDoubleStacked;
        }
        return this;
    }

    public int getId() {
        return MilkRegistry.instance().cheese().getCheeseId(this.cheese);
    }

    public int getStageId() {
        return this.cheeseStage.index;
    }

    public int getSlices() {
        return (this.isDoubleStacked ? this.topSlicesMax : 0) + this.topSlices;
    }

    public int getTopSlices() {
        return this.topSlices;
    }

    public int getTopSlicesMax() {
        return this.topSlicesMax;
    }

    public boolean hasSlices() {
        return this.getSlices() > 0;
    }

    public boolean isDoubleStacked() {
        return this.isDoubleStacked;
    }

    public float getAgeProgress() {
        return (float)this.age / (float)this.ageMax;
    }

    public boolean canAge() {
        return this.cheeseStage == EnumCheeseStage.UNAGED;
    }

    public boolean isAged() {
        return this.cheeseStage == EnumCheeseStage.AGED || this.cheeseStage == EnumCheeseStage.CUT;
    }

    public boolean isUnwaxed() {
        return this.cheeseStage == EnumCheeseStage.UNWAXED;
    }

    /*
     * Enabled aggressive block sorting
     */
    public ItemStack yankSlices(int count, boolean doYank) {
        int yankedCount = MathHelper.func_76125_a((int)count, (int)0, (int)this.getSlices());
        int quantity = yankedCount * 4;
        if (quantity <= 0) {
            return ItemStack.field_190927_a;
        }
        if (doYank) {
            if (this.topSlices <= yankedCount) {
                if (this.isDoubleStacked) {
                    this.topSlices = this.topSlicesMax + this.topSlices - yankedCount;
                    this.isDoubleStacked = false;
                } else {
                    if (this.topSlices != yankedCount) {
                        GrowthcraftMilk.logger.warn("Something is wrong with cheese yanking. Please report as bug.");
                        return ItemStack.field_190927_a;
                    }
                    this.topSlices = 0;
                }
            } else {
                this.topSlices -= yankedCount;
            }
            this.setStage(EnumCheeseStage.CUT);
        }
        return this.cheese.getCheeseItems().asStack(quantity);
    }

    public boolean stackWheel(ItemStack stack, boolean doStack) {
        if (this.isDoubleStacked) {
            return false;
        }
        if (stack.func_77973_b() == this.getBlockTopItemStack().func_77973_b()) {
            int variantID;
            int meta = stack.func_77960_j();
            EnumCheeseStage stage = CheeseUtils.getStageFromMeta(meta);
            if (stage != this.cheeseStage) {
                if (stage != EnumCheeseStage.CUT && stage != EnumCheeseStage.AGED) {
                    return false;
                }
                if (this.cheeseStage != EnumCheeseStage.CUT && this.cheeseStage != EnumCheeseStage.AGED) {
                    return false;
                }
            }
            if ((variantID = CheeseUtils.getVariantIDFromMeta(meta)) != this.cheese.getVariantID()) {
                return false;
            }
            boolean mustBeCut = stage == EnumCheeseStage.CUT || this.cheeseStage == EnumCheeseStage.CUT;
            int curSlices = CheeseUtils.getTopSlicesFromMeta(meta);
            if (curSlices != this.topSlicesMax) {
                if (this.topSlices != this.topSlicesMax) {
                    return false;
                }
                if (doStack) {
                    this.isDoubleStacked = true;
                    this.topSlices = curSlices;
                    if (mustBeCut) {
                        this.cheeseStage = EnumCheeseStage.CUT;
                    }
                }
            } else if (doStack) {
                this.isDoubleStacked = true;
                if (mustBeCut) {
                    this.cheeseStage = EnumCheeseStage.CUT;
                }
            }
            return true;
        }
        return false;
    }

    public ItemStack asFullStack() {
        return this.yankSlices(this.getSlices(), false);
    }

    public ItemStack getBlockTopItemStack() {
        return this.cheese.getCheeseBlocks().asStackForStage(this.topSlices, this.cheeseStage);
    }

    public int canWaxing(ItemStack stack) {
        if (this.isUnwaxed() && this.getType().canWax(stack)) {
            int requiredAmount;
            int n = requiredAmount = this.isDoubleStacked ? 2 : 1;
            if (stack.func_190916_E() >= requiredAmount) {
                return requiredAmount;
            }
        }
        return 0;
    }

    public int canStack(ItemStack stack) {
        return this.stackWheel(stack, false) ? 1 : 0;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        CheeseIO.writeToNBT(nbt, this.cheese);
        this.cheeseStage.writeToNBT(nbt);
        nbt.func_74768_a("age", this.age);
        nbt.func_74768_a("slices", this.topSlices);
        nbt.func_74768_a("slices_max", this.topSlicesMax);
        nbt.func_74757_a("double_stacked", this.isDoubleStacked);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.cheese = CheeseIO.loadFromNBT(nbt);
        this.cheeseStage = EnumCheeseStage.loadFromNBT(nbt);
        if (nbt.func_74764_b("age")) {
            this.age = nbt.func_74762_e("age");
        }
        if (nbt.func_74764_b("slices")) {
            this.topSlices = nbt.func_74762_e("slices");
        }
        if (nbt.func_74764_b("slices_max")) {
            this.topSlicesMax = nbt.func_74762_e("slices_max");
        }
        if (nbt.func_74764_b("double_stacked")) {
            this.isDoubleStacked = nbt.func_74767_n("double_stacked");
        }
    }

    @Override
    public boolean readFromStream(ByteBuf stream) {
        ICheeseType newCheese = CheeseIO.loadFromStream(stream);
        EnumCheeseStage newCheeseStage = EnumCheeseStage.loadFromStream(stream);
        int newAge = stream.readInt();
        int newTopSlices = stream.readInt();
        int newTopSlicesMax = stream.readInt();
        boolean newIsDoubleStacked = stream.readBoolean();
        if (!this.cheese.equals(newCheese) || !this.cheeseStage.equals((Object)newCheeseStage) || this.age != newAge || this.topSlices != newTopSlices || this.topSlicesMax != newTopSlicesMax || this.isDoubleStacked != newIsDoubleStacked) {
            this.cheese = newCheese;
            this.cheeseStage = newCheeseStage;
            this.age = newAge;
            this.topSlices = newTopSlices;
            this.topSlicesMax = newTopSlicesMax;
            this.isDoubleStacked = newIsDoubleStacked;
            return true;
        }
        return false;
    }

    @Override
    public boolean writeToStream(ByteBuf stream) {
        CheeseIO.writeToStream(stream, this.cheese);
        this.cheeseStage.writeToStream(stream);
        stream.writeInt(this.age);
        stream.writeInt(this.topSlices);
        stream.writeInt(this.topSlicesMax);
        stream.writeBoolean(this.isDoubleStacked);
        return false;
    }

    public boolean update() {
        if (!this.isAged() && this.canAge()) {
            if (this.age < this.ageMax) {
                ++this.age;
            } else {
                this.setStage(EnumCheeseStage.AGED);
            }
            return true;
        }
        return false;
    }
}

