/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.rice;

import growthcraft.rice.common.CommonProxy;
import growthcraft.rice.common.Init;
import growthcraft.rice.shared.GrowthcraftRiceUserApi;
import growthcraft.rice.shared.config.GrowthcraftRiceConfig;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="growthcraft_rice", name="Growthcraft Rice", version="4.2.0", acceptedMinecraftVersions="[1.12.2]")
public class GrowthcraftRice {
    static final String CLIENT_PROXY_CLASS = "growthcraft.rice.client.ClientProxy";
    static final String SERVER_PROXY_CLASS = "growthcraft.rice.common.CommonProxy";
    @Mod.Instance(value="growthcraft_rice")
    public static GrowthcraftRice instance;
    @SidedProxy(serverSide="growthcraft.rice.common.CommonProxy", clientSide="growthcraft.rice.client.ClientProxy")
    public static CommonProxy proxy;
    public static Logger logger;
    public static final GrowthcraftRiceUserApi userApis;

    @Mod.EventHandler
    public static void preInit(FMLPreInitializationEvent event) {
        userApis.setConfigDirectory(event.getModConfigurationDirectory());
        GrowthcraftRiceConfig.preInit(event);
        Init.preInitBlocks();
        Init.preInitItems();
        Init.preInitFluids();
        userApis.preInit();
        userApis.register();
        proxy.preInit();
        proxy.registerTileEntities();
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        proxy.init();
        Init.initBoozes();
        Init.initRecipes();
        Init.registerRecipes();
        userApis.init();
        userApis.loadConfigs();
    }

    @Mod.EventHandler
    public static void postInit(FMLPostInitializationEvent event) {
        proxy.postInit();
        userApis.postInit();
        Init.registerItemOres();
    }

    @Mod.EventHandler
    public void construct(FMLConstructionEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerBlocks((IForgeRegistry<Block>)registry);
        Init.registerFluidBlocks((IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        Init.registerItems((IForgeRegistry<Item>)registry);
        proxy.postRegisterItems();
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        Init.registerItemRenders();
        Init.registerBlockRenders();
        Init.registerFluidRenders();
    }

    @SubscribeEvent
    public void lootLoad(LootTableLoadEvent event) {
        Init.lootLoad(event);
    }

    static {
        logger = LogManager.getLogger((String)"growthcraft_rice");
        userApis = new GrowthcraftRiceUserApi();
    }
}

