/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.bees.user;

import growthcraft.api.bees.BeesRegistry;
import growthcraft.api.bees.user.UserBeeEntry;
import growthcraft.api.bees.user.UserBeesEntries;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class UserBeesConfig
extends AbstractUserJSONConfig {
    private final UserBeesEntries defaultEntries = new UserBeesEntries();
    private UserBeesEntries entries;

    public UserBeeEntry addDefault(ItemStack bee) {
        UserBeeEntry entry = new UserBeeEntry(bee);
        this.defaultEntries.data.add(entry);
        return entry;
    }

    public UserBeeEntry addDefault(Item bee) {
        return this.addDefault(new ItemStack(bee, Short.MAX_VALUE));
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserBeesEntries)this.gson.fromJson((Reader)buff, UserBeesEntries.class);
    }

    private void addBeeEntry(UserBeeEntry entry) {
        if (entry == null) {
            this.logger.error("Invalid Entry", new Object[0]);
            return;
        }
        if (entry.item == null || entry.item.isInvalid()) {
            this.logger.error("Invalid item for entry {%s}", entry);
            return;
        }
        for (ItemStack stack : entry.item.getItemStacks()) {
            BeesRegistry.instance().addBee(stack);
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Adding %d user bee entries.", this.entries.data.size());
                for (UserBeeEntry entry : this.entries.data) {
                    this.addBeeEntry(entry);
                }
            } else {
                this.logger.error("Config contains invalid data.", new Object[0]);
            }
        }
    }
}

