/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.heatsource.user;

import cpw.mods.fml.common.registry.GameRegistry;
import growthcraft.api.cellar.CellarRegistry;
import growthcraft.api.cellar.heatsource.user.UserHeatSourceEntries;
import growthcraft.api.cellar.heatsource.user.UserHeatSourceEntry;
import growthcraft.api.core.user.AbstractUserJSONConfig;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Map;
import net.minecraft.block.Block;

public class UserHeatSourcesConfig
extends AbstractUserJSONConfig {
    private final UserHeatSourceEntries defaultEntries = new UserHeatSourceEntries();
    private UserHeatSourceEntries entries;

    public UserHeatSourceEntry addDefault(String m, String b, Map<Integer, Float> s) {
        UserHeatSourceEntry entry = new UserHeatSourceEntry(m, b, s);
        this.defaultEntries.data.add(entry);
        return entry;
    }

    @Override
    protected String getDefault() {
        return this.gson.toJson((Object)this.defaultEntries);
    }

    @Override
    protected void loadFromBuffer(BufferedReader buff) throws IllegalStateException {
        this.entries = (UserHeatSourceEntries)this.gson.fromJson((Reader)buff, UserHeatSourceEntries.class);
    }

    private void addHeatSource(UserHeatSourceEntry entry) {
        Block block = GameRegistry.findBlock((String)entry.mod_id, (String)entry.block_name);
        if (block != null) {
            if (entry.states == null || entry.states.size() == 0) {
                this.logger.warn("Block contains invalid states, we will assume a wildcard, but you should probably set this. mod_id='%s' block='%s'", entry.mod_id, entry.block_name);
                CellarRegistry.instance().heatSource().addHeatSource(block, Short.MAX_VALUE);
            } else {
                for (Map.Entry<Integer, Float> pair : entry.states.entrySet()) {
                    int key = pair.getKey();
                    if (key < 0) {
                        key = Short.MAX_VALUE;
                    }
                    CellarRegistry.instance().heatSource().addHeatSource(block, key, pair.getValue().floatValue());
                }
            }
        } else {
            this.logger.error("Block could not be found, and will not be added as heat source. mod_id='%s' block='%s'", entry.mod_id, entry.block_name);
        }
    }

    @Override
    public void postInit() {
        if (this.entries != null) {
            if (this.entries.data != null) {
                this.logger.debug("Registering %d heat sources.", this.entries.data.size());
                for (UserHeatSourceEntry entry : this.entries.data) {
                    this.addHeatSource(entry);
                }
            } else {
                this.logger.error("Config data is invalid", new Object[0]);
            }
        }
    }
}

