/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.cellar.yeast;

import growthcraft.api.cellar.yeast.IYeastRegistry;
import growthcraft.api.core.item.ItemKey;
import growthcraft.api.core.item.WeightedItemStack;
import growthcraft.api.core.log.ILogger;
import growthcraft.api.core.log.NullLogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;

public class YeastRegistry
implements IYeastRegistry {
    private Set<ItemKey> yeastList = new HashSet<ItemKey>();
    private Map<BiomeDictionary.Type, Set<WeightedItemStack>> biomeTypeToYeast = new HashMap<BiomeDictionary.Type, Set<WeightedItemStack>>();
    private Map<String, Set<WeightedItemStack>> biomeNameToYeast = new HashMap<String, Set<WeightedItemStack>>();
    private Map<ItemKey, Set<BiomeDictionary.Type>> yeastToBiomeType = new HashMap<ItemKey, Set<BiomeDictionary.Type>>();
    private Map<ItemKey, Set<String>> yeastToBiomeName = new HashMap<ItemKey, Set<String>>();
    private ILogger logger = NullLogger.INSTANCE;

    @Override
    public void setLogger(ILogger l) {
        this.logger = l;
    }

    private ItemKey stackToKey(@Nonnull ItemStack stack) {
        return new ItemKey(stack);
    }

    @Override
    public void addYeast(@Nonnull ItemStack yeast) {
        this.yeastList.add(this.stackToKey(yeast));
    }

    @Override
    public boolean isYeast(@Nullable ItemStack yeast) {
        if (yeast == null) {
            return false;
        }
        if (yeast.func_77973_b() == null) {
            return false;
        }
        return this.yeastList.contains(this.stackToKey(yeast));
    }

    @Override
    public void addYeastToBiomeType(@Nonnull ItemStack yeast, int weight, @Nonnull BiomeDictionary.Type type) {
        ItemKey yeastKey;
        this.addYeast(yeast);
        if (!this.biomeTypeToYeast.containsKey(type)) {
            this.logger.debug("Initializing biome type to yeast set for %s", type);
            this.biomeTypeToYeast.put(type, new HashSet());
        }
        if (!this.yeastToBiomeType.containsKey(yeastKey = this.stackToKey(yeast))) {
            this.logger.debug("Initializing yeast to biome type set for %s", yeast);
            this.yeastToBiomeType.put(yeastKey, new HashSet());
        }
        this.biomeTypeToYeast.get(type).add(new WeightedItemStack(weight, yeast));
        this.yeastToBiomeType.get(yeastKey).add(type);
    }

    @Override
    public void addYeastToBiomeByName(@Nonnull ItemStack yeast, int weight, @Nonnull String name) {
        this.addYeast(yeast);
        ItemKey yeastKey = this.stackToKey(yeast);
        if (!this.yeastToBiomeName.containsKey(yeastKey)) {
            this.logger.debug("Initializing yeast to biome name set for %s", yeast);
            this.yeastToBiomeName.put(yeastKey, new HashSet());
        }
        this.yeastToBiomeName.get(yeastKey).add(name);
        if (!this.biomeNameToYeast.containsKey(name)) {
            this.logger.debug("Initializing biome name to yeast set for %s", name);
            this.biomeNameToYeast.put(name, new HashSet());
        }
        this.biomeNameToYeast.get(name).add(new WeightedItemStack(weight, yeast));
    }

    @Override
    public Set<WeightedItemStack> getYeastListForBiomeType(@Nonnull BiomeDictionary.Type type) {
        return this.biomeTypeToYeast.get(type);
    }

    @Override
    public Set<WeightedItemStack> getYeastListForBiomeName(@Nonnull String type) {
        return this.biomeNameToYeast.get(type);
    }

    @Override
    public Set<String> getBiomeNamesForYeast(@Nullable ItemStack yeast) {
        if (yeast == null) {
            return null;
        }
        return this.yeastToBiomeName.get(this.stackToKey(yeast));
    }

    @Override
    public Set<BiomeDictionary.Type> getBiomeTypesForYeast(@Nullable ItemStack yeast) {
        if (yeast == null) {
            return null;
        }
        return this.yeastToBiomeType.get(this.stackToKey(yeast));
    }

    @Override
    public boolean canYeastFormInBiome(@Nullable ItemStack yeast, @Nullable BiomeGenBase biome) {
        if (yeast == null || biome == null) {
            return false;
        }
        Set<String> biomeNames = this.getBiomeNamesForYeast(yeast);
        if (biomeNames != null && biomeNames.contains(biome.field_76791_y)) {
            return true;
        }
        Set<BiomeDictionary.Type> yeastBiomeList = this.getBiomeTypesForYeast(yeast);
        if (yeastBiomeList != null) {
            for (BiomeDictionary.Type t : BiomeDictionary.getTypesForBiome((BiomeGenBase)biome)) {
                if (!yeastBiomeList.contains(t)) continue;
                return true;
            }
        }
        return false;
    }
}

