/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.effect;

import growthcraft.api.core.CoreRegistry;
import growthcraft.api.core.description.Describer;
import growthcraft.api.core.effect.IPotionEffectFactory;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;

public class SimplePotionEffectFactory
implements IPotionEffectFactory {
    private int id;
    private int time;
    private int level;

    public SimplePotionEffectFactory(int i, int tm, int lvl) {
        this.id = i;
        this.time = tm;
        this.level = lvl;
    }

    public int getID() {
        return this.id;
    }

    public int getTime() {
        return this.time;
    }

    public int getLevel() {
        return this.level;
    }

    @Override
    public PotionEffect createPotionEffect(World world, Entity entity, Random random, Object data) {
        return new PotionEffect(this.getID(), this.getTime(), this.getLevel());
    }

    @Override
    public void getDescription(List<String> list) {
        PotionEffect pe = this.createPotionEffect(null, null, null, null);
        Describer.getPotionEffectDescription(list, pe);
    }

    private void readFromNBT(NBTTagCompound data) {
        this.id = data.func_74762_e("id");
        this.time = data.func_74762_e("time");
        this.level = data.func_74762_e("level");
    }

    @Override
    public void readFromNBT(NBTTagCompound data, String name) {
        if (data.func_74764_b(name)) {
            NBTTagCompound subData = data.func_74775_l(name);
            this.readFromNBT(subData);
        }
    }

    private void writeToNBT(NBTTagCompound data) {
        data.func_74768_a("id", this.getID());
        data.func_74768_a("time", this.getTime());
        data.func_74768_a("level", this.getLevel());
    }

    @Override
    public void writeToNBT(NBTTagCompound data, String name) {
        NBTTagCompound target = new NBTTagCompound();
        String factoryName = CoreRegistry.instance().getPotionEffectFactoryRegistry().getName(this.getClass());
        target.func_74778_a("__name__", factoryName);
        this.writeToNBT(target);
        data.func_74782_a(name, (NBTBase)target);
    }
}

