/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.schema;

import growthcraft.api.core.definition.IFluidStackFactory;
import growthcraft.api.core.schema.ICommentable;
import growthcraft.api.core.schema.IValidatable;
import growthcraft.api.core.util.StringUtils;
import javax.annotation.Nonnull;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class FluidStackSchema
implements IFluidStackFactory,
IValidatable,
ICommentable {
    public String comment;
    public String name;
    public int amount;

    public FluidStackSchema(@Nonnull String nm, int amt) {
        this.name = nm;
        this.amount = amt;
        this.comment = "";
    }

    public FluidStackSchema(@Nonnull FluidStack stack) {
        this.name = stack.getFluid().getName();
        this.amount = stack.amount;
        this.comment = stack.getLocalizedName();
    }

    public FluidStackSchema() {
        this.comment = "";
        this.amount = 1;
    }

    @Override
    public void setComment(@Nonnull String comm) {
        this.comment = comm;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public Fluid getFluid() {
        return FluidRegistry.getFluid((String)this.name);
    }

    @Override
    public FluidStack asFluidStack(int a) {
        Fluid fluid = this.getFluid();
        if (fluid == null) {
            return null;
        }
        return new FluidStack(fluid, a);
    }

    @Override
    public FluidStack asFluidStack() {
        return this.asFluidStack(this.amount);
    }

    public String toString() {
        return String.format("Schema<FluidStack>(comment: '%s', name: '%s', amount: %d)", StringUtils.inspect(this.comment), this.name, this.amount);
    }

    @Override
    public boolean isValid() {
        return this.asFluidStack() != null;
    }

    @Override
    public boolean isInvalid() {
        return !this.isValid();
    }
}

