/*
 * Decompiled with CFR 0.152.
 */
package growthcraft.api.core.util;

public class CuboidI {
    public int x;
    public int y;
    public int z;
    public int w;
    public int h;
    public int l;

    public CuboidI(int ix, int iy, int iz, int iw, int ih, int il) {
        this.set(ix, iy, iz, iw, ih, il);
    }

    public CuboidI(CuboidI other) {
        this(other.x, other.y, other.z, other.w, other.h, other.l);
    }

    public CuboidI() {
    }

    public CuboidI copy() {
        return new CuboidI(this);
    }

    public CuboidI set(int ix, int iy, int iz, int iw, int ih, int il) {
        this.x = ix;
        this.y = iy;
        this.z = iz;
        this.w = iw;
        this.h = ih;
        this.l = il;
        return this;
    }

    public CuboidI set(CuboidI cuboid) {
        this.set(cuboid.x, cuboid.y, cuboid.z, cuboid.w, cuboid.h, cuboid.l);
        return this;
    }

    public boolean contains(int ix, int iy, int iz) {
        return ix >= this.x && iy >= this.y && iz >= this.z && ix < this.x + this.w && iy < this.y + this.h && iz < this.z + this.l;
    }

    public int x1() {
        return this.x;
    }

    public int x2() {
        return this.x + this.w;
    }

    public int y1() {
        return this.y;
    }

    public int y2() {
        return this.y + this.h;
    }

    public int z1() {
        return this.z;
    }

    public int z2() {
        return this.z + this.l;
    }

    public boolean isEmpty() {
        return this.w == 0 || this.h == 0 || this.l == 0;
    }

    public CuboidI translate(int tx, int ty, int tz) {
        this.x += tx;
        this.y += ty;
        this.z += tz;
        return this;
    }

    public CuboidI moveto(int tx, int ty, int tz) {
        this.x = tx;
        this.y = ty;
        this.z = tz;
        return this;
    }

    public CuboidI scale(int tx, int ty, int tz) {
        this.w *= tx;
        this.h *= ty;
        this.l *= tz;
        return this;
    }

    public CuboidI scaleAll(int s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.w *= s;
        this.h *= s;
        this.l *= s;
        return this;
    }

    public CuboidI resize(int tx, int ty, int tz) {
        this.w = tx;
        this.h = ty;
        this.l = tz;
        return this;
    }

    public int[] toBoundsArray(int[] bounds) {
        assert (bounds.length == 6);
        bounds[0] = this.x;
        bounds[1] = this.y;
        bounds[2] = this.z;
        bounds[3] = this.x + this.w;
        bounds[4] = this.y + this.h;
        bounds[5] = this.z + this.l;
        return bounds;
    }

    public int[] toBoundsArray() {
        return this.toBoundsArray(new int[6]);
    }

    public int[] toIntArray(int[] target) {
        assert (target.length == 6);
        target[0] = this.x;
        target[1] = this.y;
        target[2] = this.z;
        target[3] = this.w;
        target[4] = this.h;
        target[5] = this.l;
        return target;
    }

    public int[] toIntArray() {
        return this.toIntArray(new int[6]);
    }

    public String toString() {
        return String.format("CuboidI(x: %d, y: %d, z: %d, w: %d, h: %d, l: %d)", this.x, this.y, this.z, this.w, this.h, this.l);
    }
}

